﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/pctl/detail/service/watcher/dispatcher/pctl_UnlinkDeviceDispatcher.h>

#include <nn/pctl/pctl_ResultPrivate.h>
#include <nn/pctl/detail/pctl_Log.h>
#include <nn/pctl/detail/service/pctl_ServiceConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceMemoryManagement.h>
#include <nn/pctl/detail/service/pctl_ServiceWatcher.h>
#include <nn/pctl/detail/service/common/pctl_HttpRequest.h>

#include <nn/result/result_HandlingUtility.h>

#include <nn/util/util_FormatString.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher { namespace dispatcher {

nn::Result UnlinkDeviceDispatcher::Execute(common::NetworkBuffer& bufferInfo, common::Cancelable* pCancelable, const char* token,
    ServerDeviceId deviceId, NintendoAccountId accountId) NN_NOEXCEPT
{
    // tokenヘッダーの作成
    // 22 == strlen("Authorization: Bearer ")
    size_t tokenHeaderLength = std::strlen(token) + 23;
    char* tokenHeader = reinterpret_cast<char*>(AllocateMemoryBlock(sizeof(char) * tokenHeaderLength));
    NN_RESULT_THROW_UNLESS(tokenHeader != nullptr, nn::pctl::ResultHttpErrorOutOfMemory());
    NN_UTIL_SCOPE_EXIT
    {
        FreeMemoryBlock(tokenHeader);
    };
    nn::util::SNPrintf(tokenHeader, tokenHeaderLength, "Authorization: Bearer %s", token);

    // URLの作成
    char url[UrlBufferLength_UnlinkDevice];

    nn::util::SNPrintf(url, std::extent<decltype(url)>::value, UrlFormat_UnlinkDevice,
        ServerEndpoint, deviceId, accountId);

    // 204
    nn::pctl::detail::service::common::HttpRequest request;

    NN_RESULT_DO(request.Open("DELETE", url));
    NN_RESULT_DO(request.AddRequestHeader(tokenHeader));

    NN_RESULT_TRY(common::PerformRequest(&request, bufferInfo.GetEntireBuffer(), common::NetworkBuffer::EntireBufferMemorySize, pCancelable))
        NN_RESULT_CATCH(nn::pctl::ResultUnexpectedServerError404)
        {
            // 「見つからない」は成功とみなせる
        }
    NN_RESULT_END_TRY

    NN_RESULT_SUCCESS;
}

}}}}}}
