﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/pctl/detail/ipc/pctl_IpcConfig.h>
#include <nn/pctl/detail/service/pctl_ServiceFactory.h>
#include <nn/pctl/detail/service/pctl_ServiceMain.h>
#include <nn/pctl/detail/service/common/pctl_FileSystem.h>
#include <nn/pctl/detail/service/overlay/pctl_OverlaySender.h>

namespace nn { namespace pctl { namespace detail { namespace service {

namespace
{
    std::aligned_storage<sizeof(ServiceMain)>::type g_ServiceMainStorage;
    NN_OS_ALIGNAS_THREAD_STACK uint8_t g_SettingsManagerStack[system::SettingsManager::ThreadStackSize];
}

ServiceMain* g_pMain;

void InitializeMain() NN_NOEXCEPT
{
    common::FileSystem::InitializeFileSystem();
    NN_ABORT_UNLESS_RESULT_SUCCESS(overlay::InitializeOverlaySender());

    // ファイルシステム初期化後に実行
    g_pMain = new(&g_ServiceMainStorage) ServiceMain;
    g_pMain->InitializeAndStartThread();
}

void FinalizeMain() NN_NOEXCEPT
{
    g_pMain->~ServiceMain();

    overlay::FinalizeOverlaySender();
    common::FileSystem::FinalizeFileSystem();
}

ServiceMain::ServiceMain() NN_NOEXCEPT :
    m_SettingsManager(&g_SettingsManagerStack, system::SettingsManager::ThreadStackSize),
    m_States()
{
    m_States.nextApplicationId = nn::ncm::ApplicationId::GetInvalidId();
    m_States.currentApplicationInfo.applicationId = nn::ncm::ApplicationId::GetInvalidId();
    m_States.applicationIdFromPdmEvent = nn::ncm::ApplicationId::GetInvalidId();
}

void ServiceMain::InitializeAndStartThread() NN_NOEXCEPT
{
    m_SettingsManager.LoadSettings();
    m_SettingsManager.InitializeForMasterKey();
    m_SettingsManager.StartThread();
}

}}}}
