﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/sf/impl/sf_StaticOneAllocator.h>
#include <nn/sf/sf_ObjectFactory.h>

#include "server/pcie_ManagerImpl.h"
#include "detail/pcie_IManager.h"

#include "server/pcie_LoggedStateManagerImpl.h"
#include "detail/pcie_ILoggedStateManager.h"

#include "pcie_CreateManager.h"

namespace nn { namespace pcie {


nn::sf::SharedPointer<detail::IManager> CreateManagerByDfc() NN_NOEXCEPT
{
    typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy>  Factory;
    return Factory::CreateSharedEmplaced<detail::IManager, server::ManagerImpl>();
}

nn::sf::SharedPointer<detail::ILoggedStateManager> CreateLoggedStateManagerByDfc() NN_NOEXCEPT
{
    typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy>  Factory;
    return Factory::CreateSharedEmplaced<detail::ILoggedStateManager, server::LoggedStateManagerImpl>();
}

}}
