﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


/**
 * @file
 * @brief Static Configuration
 */

#pragma once

namespace nn { namespace pcie { namespace driver { namespace detail {

/**
  * @brief Data cache line size on this system
  */
const size_t DataCacheLineSize = 64;

/**
  * @brief Minimum data alignment, corresponding with cacheline size
  */
const size_t MinDataAlignmentSize = DataCacheLineSize;

/**
 * @brief Maximum number of functions which will be recognized in a discovered PCI device
 */
const int32_t MaxEndpointFunctionCount  = 4;


/**
 * @brief Maximum number of functions which could share a single legacy IRQ
 */
const int32_t MaxFunctionsPerIrq = 4;

/**
 * @brief Maximum amount of time to wait for a port operation
 */
const uint32_t MaxPortLinkWaitTimeUs = 1000000;

/**
 * @brief Maximum number of busses, per PCI standard
 */
const int32_t MaxBusCount = 256;

/**
 * @brief Maximum number of devices, per PCI standard
 */
const int32_t MaxDeviceCount = 32;

/**
 * @brief Maximum number of devices functions, per PCI standard
 */
const int32_t MaxDeviceFunctionCount = 8;

/**
 * @brief I/O resource address alignment per PCI standard
 */
const size_t MinIoResourceAlignmentSize = 0x1000;

/**
 * @brief MEM resource address alignment per PCI standard
 */
const size_t MinMemResourceAlignmentSize = 0x100000;

/**
 * @brief Enable ASPM by default
 */
const bool IsAspmEnabledByDefault = true;

/**
 * @brief Enable ASPM substates by default
 */
const bool IsAspmL11Allowed = false;
const bool IsAspmL12Allowed = false;

/**
 * @brief Logged state statistics reporting rate limit
 */
const int LoggedStateReportingStatisticsUpdateRateInMilliHertz = 100;

/**
 * @brief Logged state error reporting rate limit
 */
const int LoggedStateReportingErrorUpdateRateInMilliHertz = 1000;

} // namespace detail
} // namespace driver
} // namespace pcie
} // namespace nn

