﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/pcie/pcie_Standard.h>
#include <nn/pcie/pcie_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pcie { namespace detail { // NOLINT(whitespace/braces)

class ISession;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISession, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISession)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(QueryFunctions, (const ::nn::sf::OutBuffer& outFunctions, ::nn::sf::Out<::std::int32_t> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireFunction, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseFunction, (::nn::pcie::FunctionHandle functionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFunctionState, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBarProfile, (::nn::sf::Out<::std::uint64_t> outBase, ::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::nn::pcie::RegionFlagMask> outRegionFlagMask, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadConfig, (::nn::sf::Out<::std::uint32_t> dataOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteConfig, (::std::uint32_t dataIn, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadBarRegion, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WriteBarRegion, (const ::nn::sf::InBuffer& input, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::CapabilityId capabilityId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(FindExtendedCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::ExtendedCapabilityId extendedCapabilityId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MapDma, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::DmaDirection direction, ::std::uint64_t procVa, ::std::uint32_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByProcVa, (::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByBusAddress, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::BusAddress busAddress))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddress, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa, ::std::uint32_t size))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddressRange, (::nn::sf::Out<::nn::pcie::BusAddress> outBase, ::nn::sf::Out<::nn::pcie::BusAddress> outSize, ::nn::pcie::FunctionHandle functionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDmaEnable, (::nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireIrq, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::IrqType irqType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseIrq, (::nn::pcie::FunctionHandle functionHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetIrqEnable, (::nn::pcie::FunctionHandle functionHandle, ::std::int32_t zeroBasedIrqNumber, bool isIrqEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAspmEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetResetUponResumeEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetFunction, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::FunctionResetOptionMask FunctionResetOptionMask))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISession)

        ::nn::Result QueryFunctions(const ::nn::sf::OutBuffer& outFunctions, ::nn::sf::Out<::std::int32_t> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(QueryFunctions, (outFunctions, outCount));
        }

        ::nn::Result AcquireFunction(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireFunction, (eventHandle, functionHandle));
        }

        ::nn::Result ReleaseFunction(::nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleaseFunction, (functionHandle));
        }

        ::nn::Result GetFunctionState(const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFunctionState, (output, functionHandle));
        }

        ::nn::Result GetBarProfile(::nn::sf::Out<::std::uint64_t> outBase, ::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::nn::pcie::RegionFlagMask> outRegionFlagMask, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBarProfile, (outBase, outSize, outRegionFlagMask, functionHandle, bar));
        }

        ::nn::Result ReadConfig(::nn::sf::Out<::std::uint32_t> dataOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadConfig, (dataOut, functionHandle, offset, width));
        }

        ::nn::Result WriteConfig(::std::uint32_t dataIn, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteConfig, (dataIn, functionHandle, offset, width));
        }

        ::nn::Result ReadBarRegion(const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadBarRegion, (output, functionHandle, bar, offset, accessWidth));
        }

        ::nn::Result WriteBarRegion(const ::nn::sf::InBuffer& input, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WriteBarRegion, (input, functionHandle, bar, offset, accessWidth));
        }

        ::nn::Result FindCapability(::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::CapabilityId capabilityId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindCapability, (offsetOut, functionHandle, capabilityId));
        }

        ::nn::Result FindExtendedCapability(::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::ExtendedCapabilityId extendedCapabilityId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(FindExtendedCapability, (offsetOut, functionHandle, extendedCapabilityId));
        }

        ::nn::Result MapDma(::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::DmaDirection direction, ::std::uint64_t procVa, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MapDma, (busAddressOut, functionHandle, direction, procVa, size));
        }

        ::nn::Result UnmapDmaByProcVa(::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnmapDmaByProcVa, (functionHandle, procVa));
        }

        ::nn::Result UnmapDmaByBusAddress(::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::BusAddress busAddress) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnmapDmaByBusAddress, (functionHandle, busAddress));
        }

        ::nn::Result GetDmaBusAddress(::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa, ::std::uint32_t size) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDmaBusAddress, (busAddressOut, functionHandle, procVa, size));
        }

        ::nn::Result GetDmaBusAddressRange(::nn::sf::Out<::nn::pcie::BusAddress> outBase, ::nn::sf::Out<::nn::pcie::BusAddress> outSize, ::nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDmaBusAddressRange, (outBase, outSize, functionHandle));
        }

        ::nn::Result SetDmaEnable(::nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDmaEnable, (functionHandle, isBusMasterEnabled));
        }

        ::nn::Result AcquireIrq(::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::IrqType irqType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireIrq, (eventHandle, functionHandle, irqType));
        }

        ::nn::Result ReleaseIrq(::nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReleaseIrq, (functionHandle));
        }

        ::nn::Result SetIrqEnable(::nn::pcie::FunctionHandle functionHandle, ::std::int32_t zeroBasedIrqNumber, bool isIrqEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetIrqEnable, (functionHandle, zeroBasedIrqNumber, isIrqEnabled));
        }

        ::nn::Result SetAspmEnable(::nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAspmEnable, (functionHandle, isEnabled));
        }

        ::nn::Result SetResetUponResumeEnable(::nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetResetUponResumeEnable, (functionHandle, isEnabled));
        }

        ::nn::Result ResetFunction(::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::FunctionResetOptionMask FunctionResetOptionMask) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetFunction, (functionHandle, FunctionResetOptionMask));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISession
    {
    public:
        nn::Result QueryFunctions(const nn::sf::OutBuffer& outFunctions, nn::sf::Out<std::int32_t> outCount) NN_NOEXCEPT;
        nn::Result AcquireFunction(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
        nn::Result ReleaseFunction(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
        nn::Result GetFunctionState(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
        nn::Result GetBarProfile(nn::sf::Out<std::uint64_t> outBase, nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<nn::pcie::RegionFlagMask> outRegionFlagMask, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar) NN_NOEXCEPT;
        nn::Result ReadConfig(nn::sf::Out<std::uint32_t> dataOut, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT;
        nn::Result WriteConfig(std::uint32_t dataIn, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT;
        nn::Result ReadBarRegion(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT;
        nn::Result WriteBarRegion(const nn::sf::InBuffer& input, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT;
        nn::Result FindCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::CapabilityId capabilityId) NN_NOEXCEPT;
        nn::Result FindExtendedCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::ExtendedCapabilityId extendedCapabilityId) NN_NOEXCEPT;
        nn::Result MapDma(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::DmaDirection direction, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT;
        nn::Result UnmapDmaByProcVa(nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa) NN_NOEXCEPT;
        nn::Result UnmapDmaByBusAddress(nn::pcie::FunctionHandle functionHandle, nn::pcie::BusAddress busAddress) NN_NOEXCEPT;
        nn::Result GetDmaBusAddress(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT;
        nn::Result GetDmaBusAddressRange(nn::sf::Out<nn::pcie::BusAddress> outBase, nn::sf::Out<nn::pcie::BusAddress> outSize, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
        nn::Result SetDmaEnable(nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled) NN_NOEXCEPT;
        nn::Result AcquireIrq(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle, nn::pcie::IrqType irqType) NN_NOEXCEPT;
        nn::Result ReleaseIrq(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
        nn::Result SetIrqEnable(nn::pcie::FunctionHandle functionHandle, std::int32_t zeroBasedIrqNumber, bool isIrqEnabled) NN_NOEXCEPT;
        nn::Result SetAspmEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT;
        nn::Result SetResetUponResumeEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT;
        nn::Result ResetFunction(nn::pcie::FunctionHandle functionHandle, nn::pcie::FunctionResetOptionMask FunctionResetOptionMask) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result QueryFunctions(const nn::sf::OutBuffer& outFunctions, nn::sf::Out<std::int32_t> outCount) NN_NOEXCEPT;
    nn::Result AcquireFunction(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
    nn::Result ReleaseFunction(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
    nn::Result GetFunctionState(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
    nn::Result GetBarProfile(nn::sf::Out<std::uint64_t> outBase, nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<nn::pcie::RegionFlagMask> outRegionFlagMask, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar) NN_NOEXCEPT;
    nn::Result ReadConfig(nn::sf::Out<std::uint32_t> dataOut, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT;
    nn::Result WriteConfig(std::uint32_t dataIn, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT;
    nn::Result ReadBarRegion(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT;
    nn::Result WriteBarRegion(const nn::sf::InBuffer& input, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT;
    nn::Result FindCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::CapabilityId capabilityId) NN_NOEXCEPT;
    nn::Result FindExtendedCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::ExtendedCapabilityId extendedCapabilityId) NN_NOEXCEPT;
    nn::Result MapDma(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::DmaDirection direction, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT;
    nn::Result UnmapDmaByProcVa(nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa) NN_NOEXCEPT;
    nn::Result UnmapDmaByBusAddress(nn::pcie::FunctionHandle functionHandle, nn::pcie::BusAddress busAddress) NN_NOEXCEPT;
    nn::Result GetDmaBusAddress(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT;
    nn::Result GetDmaBusAddressRange(nn::sf::Out<nn::pcie::BusAddress> outBase, nn::sf::Out<nn::pcie::BusAddress> outSize, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
    nn::Result SetDmaEnable(nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled) NN_NOEXCEPT;
    nn::Result AcquireIrq(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle, nn::pcie::IrqType irqType) NN_NOEXCEPT;
    nn::Result ReleaseIrq(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT;
    nn::Result SetIrqEnable(nn::pcie::FunctionHandle functionHandle, std::int32_t zeroBasedIrqNumber, bool isIrqEnabled) NN_NOEXCEPT;
    nn::Result SetAspmEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT;
    nn::Result SetResetUponResumeEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT;
    nn::Result ResetFunction(nn::pcie::FunctionHandle functionHandle, nn::pcie::FunctionResetOptionMask FunctionResetOptionMask) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pcie::detail::ISession))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryFunctions, (const ::nn::sf::OutBuffer& outFunctions, ::nn::sf::Out<::std::int32_t> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(QueryFunctions, (outFunctions, outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireFunction, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireFunction, (eventHandle, functionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseFunction, (::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleaseFunction, (functionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFunctionState, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFunctionState, (output, functionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBarProfile, (::nn::sf::Out<::std::uint64_t> outBase, ::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::nn::pcie::RegionFlagMask> outRegionFlagMask, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBarProfile, (outBase, outSize, outRegionFlagMask, functionHandle, bar));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadConfig, (::nn::sf::Out<::std::uint32_t> dataOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadConfig, (dataOut, functionHandle, offset, width));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteConfig, (::std::uint32_t dataIn, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteConfig, (dataIn, functionHandle, offset, width));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadBarRegion, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadBarRegion, (output, functionHandle, bar, offset, accessWidth));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteBarRegion, (const ::nn::sf::InBuffer& input, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WriteBarRegion, (input, functionHandle, bar, offset, accessWidth));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::CapabilityId capabilityId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindCapability, (offsetOut, functionHandle, capabilityId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindExtendedCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::ExtendedCapabilityId extendedCapabilityId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(FindExtendedCapability, (offsetOut, functionHandle, extendedCapabilityId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MapDma, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::DmaDirection direction, ::std::uint64_t procVa, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MapDma, (busAddressOut, functionHandle, direction, procVa, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByProcVa, (::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnmapDmaByProcVa, (functionHandle, procVa));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByBusAddress, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::BusAddress busAddress))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnmapDmaByBusAddress, (functionHandle, busAddress));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddress, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa, ::std::uint32_t size))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDmaBusAddress, (busAddressOut, functionHandle, procVa, size));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddressRange, (::nn::sf::Out<::nn::pcie::BusAddress> outBase, ::nn::sf::Out<::nn::pcie::BusAddress> outSize, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDmaBusAddressRange, (outBase, outSize, functionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDmaEnable, (::nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDmaEnable, (functionHandle, isBusMasterEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireIrq, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::IrqType irqType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireIrq, (eventHandle, functionHandle, irqType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseIrq, (::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReleaseIrq, (functionHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIrqEnable, (::nn::pcie::FunctionHandle functionHandle, ::std::int32_t zeroBasedIrqNumber, bool isIrqEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetIrqEnable, (functionHandle, zeroBasedIrqNumber, isIrqEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAspmEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAspmEnable, (functionHandle, isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetResetUponResumeEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetResetUponResumeEnable, (functionHandle, isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetFunction, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::FunctionResetOptionMask FunctionResetOptionMask))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetFunction, (functionHandle, FunctionResetOptionMask));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pcie::detail::ISession>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pcie::detail::ISession))

    // nn::Result QueryFunctions(const nn::sf::OutBuffer& outFunctions, nn::sf::Out<std::int32_t> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(QueryFunctions)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outFunctions, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outFunctions))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFunctions), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(QueryFunctions)

    // nn::Result AcquireFunction(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireFunction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireFunction)

    // nn::Result ReleaseFunction(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseFunction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseFunction)

    // nn::Result GetFunctionState(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFunctionState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFunctionState)

    // nn::Result GetBarProfile(nn::sf::Out<std::uint64_t> outBase, nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<nn::pcie::RegionFlagMask> outRegionFlagMask, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBarProfile)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bar, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (bar, functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outRegionFlagMask, (::nn::pcie::RegionFlagMask), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBase, (::std::uint64_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outRegionFlagMask, outBase, outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outRegionFlagMask), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bar)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBarProfile)

    // nn::Result ReadConfig(nn::sf::Out<std::uint32_t> dataOut, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::nn::pcie::BusAccessWidth), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (functionHandle, offset, width))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(dataOut, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (dataOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadConfig)

    // nn::Result WriteConfig(std::uint32_t dataIn, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteConfig)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dataIn, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(width, (::nn::pcie::BusAccessWidth), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (dataIn, functionHandle, offset, width))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dataIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(width)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteConfig)

    // nn::Result ReadBarRegion(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadBarRegion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bar, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessWidth, (::nn::pcie::BusAccessWidth), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (bar, functionHandle, offset, accessWidth))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bar), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessWidth)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadBarRegion)

    // nn::Result WriteBarRegion(const nn::sf::InBuffer& input, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WriteBarRegion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(input, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (input))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bar, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessWidth, (::nn::pcie::BusAccessWidth), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (bar, functionHandle, offset, accessWidth))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(input), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bar), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessWidth)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WriteBarRegion)

    // nn::Result FindCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::CapabilityId capabilityId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindCapability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(capabilityId, (::nn::pcie::CapabilityId), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, capabilityId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(offsetOut, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (offsetOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offsetOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(capabilityId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindCapability)

    // nn::Result FindExtendedCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::ExtendedCapabilityId extendedCapabilityId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FindExtendedCapability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(extendedCapabilityId, (::nn::pcie::ExtendedCapabilityId), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, extendedCapabilityId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(offsetOut, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (offsetOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offsetOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(extendedCapabilityId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FindExtendedCapability)

    // nn::Result MapDma(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::DmaDirection direction, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MapDma)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(direction, (::nn::pcie::DmaDirection), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(procVa, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (functionHandle, direction, size, procVa))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(busAddressOut, (::nn::pcie::BusAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (busAddressOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(busAddressOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(direction), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(procVa), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MapDma)

    // nn::Result UnmapDmaByProcVa(nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnmapDmaByProcVa)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(procVa, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, procVa))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(procVa)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnmapDmaByProcVa)

    // nn::Result UnmapDmaByBusAddress(nn::pcie::FunctionHandle functionHandle, nn::pcie::BusAddress busAddress) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnmapDmaByBusAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(busAddress, (::nn::pcie::BusAddress), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, busAddress))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(busAddress)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnmapDmaByBusAddress)

    // nn::Result GetDmaBusAddress(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDmaBusAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(size, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(procVa, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (functionHandle, size, procVa))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(busAddressOut, (::nn::pcie::BusAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (busAddressOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(busAddressOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(procVa), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(size)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDmaBusAddress)

    // nn::Result GetDmaBusAddressRange(nn::sf::Out<nn::pcie::BusAddress> outBase, nn::sf::Out<nn::pcie::BusAddress> outSize, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDmaBusAddressRange)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBase, (::nn::pcie::BusAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::nn::pcie::BusAddress), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outBase, outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBase), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDmaBusAddressRange)

    // nn::Result SetDmaEnable(nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDmaEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isBusMasterEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isBusMasterEnabled, functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isBusMasterEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDmaEnable)

    // nn::Result AcquireIrq(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle, nn::pcie::IrqType irqType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireIrq)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(eventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (eventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(irqType, (::nn::pcie::IrqType), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, irqType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(irqType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireIrq)

    // nn::Result ReleaseIrq(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReleaseIrq)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReleaseIrq)

    // nn::Result SetIrqEnable(nn::pcie::FunctionHandle functionHandle, std::int32_t zeroBasedIrqNumber, bool isIrqEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetIrqEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isIrqEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(zeroBasedIrqNumber, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (isIrqEnabled, functionHandle, zeroBasedIrqNumber))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(zeroBasedIrqNumber), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isIrqEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetIrqEnable)

    // nn::Result SetAspmEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAspmEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isEnabled, functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAspmEnable)

    // nn::Result SetResetUponResumeEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetResetUponResumeEnable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isEnabled, functionHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetResetUponResumeEnable)

    // nn::Result ResetFunction(nn::pcie::FunctionHandle functionHandle, nn::pcie::FunctionResetOptionMask FunctionResetOptionMask) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetFunction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(functionHandle, (::nn::pcie::FunctionHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(FunctionResetOptionMask, (::nn::pcie::FunctionResetOptionMask), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (functionHandle, FunctionResetOptionMask))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(functionHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(FunctionResetOptionMask)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetFunction)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::FunctionHandle), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::RegionFlagMask), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::BusAccessWidth), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::CapabilityId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::ExtendedCapabilityId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::BusAddress), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::DmaDirection), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::IrqType), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pcie::FunctionResetOptionMask), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pcie::detail::ISession, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pcie::detail::ISession))

    // nn::Result QueryFunctions(const nn::sf::OutBuffer& outFunctions, nn::sf::Out<std::int32_t> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(QueryFunctions, (const ::nn::sf::OutBuffer& outFunctions, ::nn::sf::Out<::std::int32_t> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(QueryFunctions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFunctions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(QueryFunctions)
    }

    // nn::Result AcquireFunction(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireFunction, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireFunction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireFunction)
    }

    // nn::Result ReleaseFunction(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseFunction, (::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseFunction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseFunction)
    }

    // nn::Result GetFunctionState(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFunctionState, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFunctionState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFunctionState)
    }

    // nn::Result GetBarProfile(nn::sf::Out<std::uint64_t> outBase, nn::sf::Out<std::uint64_t> outSize, nn::sf::Out<nn::pcie::RegionFlagMask> outRegionFlagMask, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBarProfile, (::nn::sf::Out<::std::uint64_t> outBase, ::nn::sf::Out<::std::uint64_t> outSize, ::nn::sf::Out<::nn::pcie::RegionFlagMask> outRegionFlagMask, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBarProfile)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outRegionFlagMask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bar)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBarProfile)
    }

    // nn::Result ReadConfig(nn::sf::Out<std::uint32_t> dataOut, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadConfig, (::nn::sf::Out<::std::uint32_t> dataOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadConfig)
    }

    // nn::Result WriteConfig(std::uint32_t dataIn, nn::pcie::FunctionHandle functionHandle, std::uint32_t offset, nn::pcie::BusAccessWidth width) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteConfig, (::std::uint32_t dataIn, ::nn::pcie::FunctionHandle functionHandle, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth width))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteConfig)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dataIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(width)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteConfig)
    }

    // nn::Result ReadBarRegion(const nn::sf::OutBuffer& output, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadBarRegion, (const ::nn::sf::OutBuffer& output, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadBarRegion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bar)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessWidth)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadBarRegion)
    }

    // nn::Result WriteBarRegion(const nn::sf::InBuffer& input, nn::pcie::FunctionHandle functionHandle, std::uint8_t bar, std::uint32_t offset, nn::pcie::BusAccessWidth accessWidth) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WriteBarRegion, (const ::nn::sf::InBuffer& input, ::nn::pcie::FunctionHandle functionHandle, ::std::uint8_t bar, ::std::uint32_t offset, ::nn::pcie::BusAccessWidth accessWidth))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WriteBarRegion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(input)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bar)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessWidth)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WriteBarRegion)
    }

    // nn::Result FindCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::CapabilityId capabilityId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::CapabilityId capabilityId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindCapability)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offsetOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(capabilityId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindCapability)
    }

    // nn::Result FindExtendedCapability(nn::sf::Out<std::uint32_t> offsetOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::ExtendedCapabilityId extendedCapabilityId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(FindExtendedCapability, (::nn::sf::Out<::std::uint32_t> offsetOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::ExtendedCapabilityId extendedCapabilityId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FindExtendedCapability)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offsetOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(extendedCapabilityId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FindExtendedCapability)
    }

    // nn::Result MapDma(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, nn::pcie::DmaDirection direction, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MapDma, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::DmaDirection direction, ::std::uint64_t procVa, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MapDma)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(busAddressOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(direction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(procVa)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MapDma)
    }

    // nn::Result UnmapDmaByProcVa(nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByProcVa, (::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnmapDmaByProcVa)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(procVa)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnmapDmaByProcVa)
    }

    // nn::Result UnmapDmaByBusAddress(nn::pcie::FunctionHandle functionHandle, nn::pcie::BusAddress busAddress) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnmapDmaByBusAddress, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::BusAddress busAddress))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnmapDmaByBusAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(busAddress)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnmapDmaByBusAddress)
    }

    // nn::Result GetDmaBusAddress(nn::sf::Out<nn::pcie::BusAddress> busAddressOut, nn::pcie::FunctionHandle functionHandle, std::uint64_t procVa, std::uint32_t size) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddress, (::nn::sf::Out<::nn::pcie::BusAddress> busAddressOut, ::nn::pcie::FunctionHandle functionHandle, ::std::uint64_t procVa, ::std::uint32_t size))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDmaBusAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(busAddressOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(procVa)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(size)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDmaBusAddress)
    }

    // nn::Result GetDmaBusAddressRange(nn::sf::Out<nn::pcie::BusAddress> outBase, nn::sf::Out<nn::pcie::BusAddress> outSize, nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDmaBusAddressRange, (::nn::sf::Out<::nn::pcie::BusAddress> outBase, ::nn::sf::Out<::nn::pcie::BusAddress> outSize, ::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDmaBusAddressRange)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBase)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDmaBusAddressRange)
    }

    // nn::Result SetDmaEnable(nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDmaEnable, (::nn::pcie::FunctionHandle functionHandle, bool isBusMasterEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDmaEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isBusMasterEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDmaEnable)
    }

    // nn::Result AcquireIrq(nn::sf::Out<nn::sf::NativeHandle> eventHandle, nn::pcie::FunctionHandle functionHandle, nn::pcie::IrqType irqType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireIrq, (::nn::sf::Out<::nn::sf::NativeHandle> eventHandle, ::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::IrqType irqType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireIrq)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(irqType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireIrq)
    }

    // nn::Result ReleaseIrq(nn::pcie::FunctionHandle functionHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReleaseIrq, (::nn::pcie::FunctionHandle functionHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReleaseIrq)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReleaseIrq)
    }

    // nn::Result SetIrqEnable(nn::pcie::FunctionHandle functionHandle, std::int32_t zeroBasedIrqNumber, bool isIrqEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetIrqEnable, (::nn::pcie::FunctionHandle functionHandle, ::std::int32_t zeroBasedIrqNumber, bool isIrqEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetIrqEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(zeroBasedIrqNumber)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isIrqEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetIrqEnable)
    }

    // nn::Result SetAspmEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAspmEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAspmEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAspmEnable)
    }

    // nn::Result SetResetUponResumeEnable(nn::pcie::FunctionHandle functionHandle, bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetResetUponResumeEnable, (::nn::pcie::FunctionHandle functionHandle, bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetResetUponResumeEnable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetResetUponResumeEnable)
    }

    // nn::Result ResetFunction(nn::pcie::FunctionHandle functionHandle, nn::pcie::FunctionResetOptionMask FunctionResetOptionMask) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetFunction, (::nn::pcie::FunctionHandle functionHandle, ::nn::pcie::FunctionResetOptionMask FunctionResetOptionMask))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetFunction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(functionHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(FunctionResetOptionMask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetFunction)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pcie::detail::ISession>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pcie::detail::ISession))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(QueryFunctions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outFunctions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(QueryFunctions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outFunctions),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireFunction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseFunction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFunctionState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFunctionState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBarProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBarProfile)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outRegionFlagMask),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bar)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(dataOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteConfig)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dataIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(width)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadBarRegion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadBarRegion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bar),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessWidth)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WriteBarRegion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(input)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WriteBarRegion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(input),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bar),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessWidth)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindCapability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindCapability)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(offsetOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(capabilityId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FindExtendedCapability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FindExtendedCapability)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(offsetOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(extendedCapabilityId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MapDma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MapDma)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(busAddressOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(direction),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(procVa),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnmapDmaByProcVa)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnmapDmaByProcVa)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(procVa)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnmapDmaByBusAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnmapDmaByBusAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(busAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDmaBusAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDmaBusAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(busAddressOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(procVa),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(size)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDmaBusAddressRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDmaBusAddressRange)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBase),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDmaEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDmaEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isBusMasterEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireIrq)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(eventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireIrq)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(eventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(irqType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReleaseIrq)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReleaseIrq)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetIrqEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetIrqEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(zeroBasedIrqNumber),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isIrqEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAspmEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAspmEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetResetUponResumeEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetResetUponResumeEnable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetFunction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(functionHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(FunctionResetOptionMask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(QueryFunctions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFunctionState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBarProfile)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteConfig)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadBarRegion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WriteBarRegion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindCapability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FindExtendedCapability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MapDma)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnmapDmaByProcVa)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnmapDmaByBusAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDmaBusAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDmaBusAddressRange)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDmaEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireIrq)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReleaseIrq)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetIrqEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAspmEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetResetUponResumeEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetFunction)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pcie::detail::ISession))
