﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pcie { namespace detail { // NOLINT(whitespace/braces)

class ILoggedStateManager;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILoggedStateManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILoggedStateManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedState, (const ::nn::sf::OutBuffer& output, ::nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedStateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILoggedStateManager)

        ::nn::Result GetLoggedState(const ::nn::sf::OutBuffer& output, ::nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLoggedState, (output, isLoggedStatePendingOut, isCleared));
        }

        ::nn::Result GetLoggedStateEvent(::nn::sf::Out<::nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLoggedStateEvent, (loggedStateEventHandle, isStatisticReported));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILoggedStateManager
    {
    public:
        nn::Result GetLoggedState(const nn::sf::OutBuffer& output, nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared) NN_NOEXCEPT;
        nn::Result GetLoggedStateEvent(nn::sf::Out<nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetLoggedState(const nn::sf::OutBuffer& output, nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared) NN_NOEXCEPT;
    nn::Result GetLoggedStateEvent(nn::sf::Out<nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pcie::detail::ILoggedStateManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedState, (const ::nn::sf::OutBuffer& output, ::nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLoggedState, (output, isLoggedStatePendingOut, isCleared));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedStateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLoggedStateEvent, (loggedStateEventHandle, isStatisticReported));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pcie::detail::ILoggedStateManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pcie::detail::ILoggedStateManager))

    // nn::Result GetLoggedState(const nn::sf::OutBuffer& output, nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLoggedState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(output, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (output))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isCleared, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isCleared))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(isLoggedStatePendingOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (isLoggedStatePendingOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(output), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isLoggedStatePendingOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isCleared)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLoggedState)

    // nn::Result GetLoggedStateEvent(nn::sf::Out<nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLoggedStateEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(loggedStateEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (loggedStateEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isStatisticReported, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isStatisticReported))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(loggedStateEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isStatisticReported)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLoggedStateEvent)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pcie::detail::ILoggedStateManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pcie::detail::ILoggedStateManager))

    // nn::Result GetLoggedState(const nn::sf::OutBuffer& output, nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedState, (const ::nn::sf::OutBuffer& output, ::nn::sf::Out<bool> isLoggedStatePendingOut, bool isCleared))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLoggedState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(output)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isLoggedStatePendingOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isCleared)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLoggedState)
    }

    // nn::Result GetLoggedStateEvent(nn::sf::Out<nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLoggedStateEvent, (::nn::sf::Out<::nn::sf::NativeHandle> loggedStateEventHandle, bool isStatisticReported))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLoggedStateEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(loggedStateEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isStatisticReported)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLoggedStateEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pcie::detail::ILoggedStateManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pcie::detail::ILoggedStateManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLoggedState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(output)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLoggedState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(output),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(isLoggedStatePendingOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isCleared)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLoggedStateEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(loggedStateEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLoggedStateEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(loggedStateEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isStatisticReported)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLoggedState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLoggedStateEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pcie::detail::ILoggedStateManager))
