﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if defined NN_BUILD_CONFIG_SPEC_NX && defined NN_BUILD_CONFIG_ADDRESS_64
extern nn::Bit8 NN_OMM_CHARGING_BIN_begin[];
extern nn::Bit8 NN_OMM_CHARGING_BIN_end[];
extern nn::Bit8 NN_OMM_CHARGING_RED_BIN_begin[];
extern nn::Bit8 NN_OMM_CHARGING_RED_BIN_end[];
extern nn::Bit8 NN_OMM_LOW_BATTERY_BIN_begin[];
extern nn::Bit8 NN_OMM_LOW_BATTERY_BIN_end[];
extern nn::Bit8 NN_OMM_LOW_BATTERY_CHARGING_BIN_begin[];
extern nn::Bit8 NN_OMM_LOW_BATTERY_CHARGING_BIN_end[];
extern nn::Bit8 NN_OMM_STARTUP_LOGO_BIN_begin[];
extern nn::Bit8 NN_OMM_STARTUP_LOGO_BIN_end[];
extern nn::Bit8 NN_OMM_CARD_UPDATE_PROCEESING_BIN_begin[];
extern nn::Bit8 NN_OMM_CARD_UPDATE_PROCEESING_BIN_end[];
#else
const nn::Bit8* const NN_OMM_CHARGING_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_CHARGING_BIN_end = nullptr;
const nn::Bit8* const NN_OMM_CHARGING_RED_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_CHARGING_RED_BIN_end = nullptr;
const nn::Bit8* const NN_OMM_LOW_BATTERY_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_LOW_BATTERY_BIN_end = nullptr;
const nn::Bit8* const NN_OMM_LOW_BATTERY_CHARGING_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_LOW_BATTERY_CHARGING_BIN_end = nullptr;
const nn::Bit8* const NN_OMM_STARTUP_LOGO_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_STARTUP_LOGO_BIN_end = nullptr;
const nn::Bit8* const NN_OMM_CARD_UPDATE_PROCEESING_BIN_begin = nullptr;
const nn::Bit8* const NN_OMM_CARD_UPDATE_PROCEESING_BIN_end = nullptr;
#endif

namespace nn { namespace omm { namespace srv {
    const Bit8* const ChargingData = NN_OMM_CHARGING_BIN_begin;
    const size_t ChargingDataSize = static_cast<size_t>(NN_OMM_CHARGING_BIN_end - NN_OMM_CHARGING_BIN_begin);
    const int ChargingPointX = 26;
    const int ChargingPointY = 28;
    const int ChargingWidth = 76;
    const int ChargingHeight = 28;

    const Bit8* const ChargingRedData = NN_OMM_CHARGING_RED_BIN_begin;
    const size_t ChargingRedDataSize = static_cast<size_t>(NN_OMM_CHARGING_RED_BIN_end - NN_OMM_CHARGING_RED_BIN_begin);
    const int ChargingRedPointX = 26;
    const int ChargingRedPointY = 28;
    const int ChargingRedWidth = 76;
    const int ChargingRedHeight = 28;

    const Bit8* const LowBatteryData = NN_OMM_LOW_BATTERY_BIN_begin;
    const size_t LowBatteryDataSize = static_cast<size_t>(NN_OMM_LOW_BATTERY_BIN_end - NN_OMM_LOW_BATTERY_BIN_begin);
    const int LowBatteryPointX = 26;
    const int LowBatteryPointY = 28;
    const int LowBatteryWidth = 52;
    const int LowBatteryHeight = 28;

    const Bit8* const LowBatteryChargingData = NN_OMM_LOW_BATTERY_CHARGING_BIN_begin;
    const size_t LowBatteryChargingDataSize = static_cast<size_t>(NN_OMM_LOW_BATTERY_CHARGING_BIN_end - NN_OMM_LOW_BATTERY_CHARGING_BIN_begin);
    const int LowBatteryChargingPointX = 26;
    const int LowBatteryChargingPointY = 28;
    const int LowBatteryChargingWidth = 76;
    const int LowBatteryChargingHeight = 28;

    const Bit8* const CardUpdateProcessingData = NN_OMM_CARD_UPDATE_PROCEESING_BIN_begin;
    const size_t CardUpdateProcessingDataSize = static_cast<size_t>(NN_OMM_CARD_UPDATE_PROCEESING_BIN_end - NN_OMM_CARD_UPDATE_PROCEESING_BIN_begin);
    const int CardUpdateProcessingPointX = 26;
    const int CardUpdateProcessingPointY = 28;
    const int CardUpdateProcessingWidth = 76;
    const int CardUpdateProcessingHeight = 28;

}}}
