﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_Api.h>
#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_ResultPrivate.h>
#include <nn/olsc/srv/util/olsc_CancelListener.h>
#include <nn/olsc/srv/util/olsc_Network.h>
#include <nn/olsc/srv/util/olsc_Os.h>
#include <nn/os/os_MultipleWaitUtility.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

namespace nn { namespace olsc { namespace srv { namespace util {

Result SubmitAndWaitNetworkConnection(nn::nifm::NetworkConnection& connection, nifm::RequirementPreset preset, nn::util::Cancelable& cancelable) NN_NOEXCEPT
{
    auto handle = connection.GetRequestHandle();
    NN_ABORT_UNLESS_RESULT_SUCCESS(SetRequestRequirementPreset(handle, preset));
    connection.SubmitRequest();

    if (connection.IsAvailable())
    {
        NN_RESULT_SUCCESS;
    }

    SimpleCancelListener cancelListener;
    auto& cancelEvent = cancelListener.GetEvent();
    cancelable.AttachListener(&cancelListener);
    NN_UTIL_SCOPE_EXIT{
        cancelable.DetachListener();
    };

    auto& connectionEvent = connection.GetSystemEvent();

    const int CancelEventIndex = 0;
    const int ConnectionEventIndex = 1;
    auto signaled = os::WaitAny(cancelEvent.GetBase(), connectionEvent.GetBase());

    switch (signaled)
    {
    case CancelEventIndex:
        connection.CancelRequest();
        NN_RESULT_THROW(olsc::ResultCanceledWhileConnecting());

    case ConnectionEventIndex:
        break;

    default:
        NN_UNEXPECTED_DEFAULT;
    }
    NN_RESULT_THROW_UNLESS(connection.IsAvailable(), olsc::ResultNetworkConnectionUnavailable());
    NN_RESULT_SUCCESS;
}

}}}} //namespace nn::olsc::srv::util
