﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "../adaptor/olsc_PolicyInfoAdaptor.h"

#include <nn/http/json/http_RapidJsonApi.h>
#include <nn/http/json/http_JsonErrorMap.h>
#include <nn/http/stream/http_CurlInputStream.h>
#include <nn/http/stream/http_ClientCertificate.h>

#include <nn/olsc/srv/transfer/olsc_TransferUtil.h>
#include <nn/olsc/srv/transfer/olsc_PolicyInfoDownload.h>

#include <nn/util/util_TFormatString.h>
#include <nn/util/util_Base64.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {
namespace
{

Result SetupStreamForGetPolicyInfoImpl(http::stream::CurlInputStream& stream, curl_slist** headers, const char* url, void* workBuffer, size_t workBufferSize)
{
    struct Buffer
    {
        union
        {
            struct
            {
                char clientCertBuffer[DeviceCertBufferSizeMax];
                char stringBuffer[IoBufferSizeMin];
                char inputBuffer[IoBufferSizeMin];
            } io;
        } u;
    };

    NN_SDK_REQUIRES(workBufferSize >= sizeof(Buffer));
    NN_SDK_REQUIRES_NOT_NULL(workBuffer);
    NN_SDK_REQUIRES(reinterpret_cast<uintptr_t>(workBuffer) % std::alignment_of<Buffer>::value == 0);

    NN_RESULT_DO(stream.Initialize());

    // リクエストの作成
    auto* buffer = reinterpret_cast<Buffer*>(workBuffer);
    stream.SetStringBuffer(buffer->u.io.stringBuffer, sizeof(buffer->u.io.stringBuffer));
    stream.SetInputBuffer(buffer->u.io.inputBuffer, workBufferSize - offsetof(Buffer, u.io.inputBuffer));

    // リクエスト生成
    NN_RESULT_DO(stream.SetHeaders(*headers));

    // SSL / URL設定
    http::stream::CertIoBuffer certBuffer = {buffer->u.io.clientCertBuffer, sizeof(buffer->u.io.clientCertBuffer)};
    NN_RESULT_DO(stream.SetSslContextHandler(http::stream::SslCtxHandlerWithClientCert, &certBuffer));

    NN_RESULT_DO(stream.SetUrl(url));
    NN_RESULT_SUCCESS;
}

Result GetPolicyInfoImpl(nn::olsc::srv::adaptor::AdaptorBase<8,128>& adaptor, CURL* curlHandle, const char* url, void* workBuffer, size_t workBufferSize, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
{
    struct curl_slist *headers = nullptr;
    NN_UTIL_SCOPE_EXIT
    {
        curl_slist_free_all(headers);
    };
    http::stream::CurlInputStream stream(curlHandle, pCancelable);
    NN_RESULT_DO(SetupStreamForGetPolicyInfoImpl(stream, &headers, url, workBuffer, workBufferSize));
    NN_RESULT_DO(stream.Open());
    NN_RESULT_DO(http::json::ImportJsonByRapidJson<http::json::DefaultJsonErrorMap>(adaptor, stream, pCancelable));
    NN_RESULT_DO(adaptor.GetResult());
    NN_RESULT_DO(stream.GetResult());

    NN_RESULT_SUCCESS;
}
}

Result GetPolicyInfo(PolicyInfo* pOut, ApplicationId appId, uint32_t version, CURL* curlHandle, void* workBuffer, size_t workBufferSize, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT
{
    // TODO : サーバー対応後、 Akamai トークンを送る

    // URL の作成
    char url[256];
    auto l = CreateUrlForPolicyInfo(url, sizeof(url), appId, version);
    NN_SDK_ASSERT(static_cast<uint32_t>(l) < sizeof(url));
    NN_UNUSED(l);

    PolicyInfo policy;
    olsc::srv::adaptor::PolicyInfoAdaptor adaptor;
    NN_RESULT_DO(GetPolicyInfoImpl(adaptor, curlHandle, url, workBuffer, workBufferSize, pCancelable));
    NN_RESULT_DO(adaptor.GetPolicyInfo(&policy));

    *pOut = policy;
    NN_RESULT_SUCCESS;
}


}}}} //namespace nn::olsc::srv::transfer

