﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/olsc/srv/olsc_ServiceResource.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace olsc { namespace srv {

sf::SharedPointer<IOlscServiceForSystemService> ServiceResource::GetServiceForSystemService() NN_NOEXCEPT
{
    return sf::CreateSharedObjectWithoutManagement<IOlscServiceForSystemService, Service>(&m_ObjectMemoryResourceHolder.GetMemoryResourceRef(), &m_Service);
}

const util::MountInfo ServiceResource::DeviceSaveInfo =
{
    0x8000000000000150,
    2 * 1024 * 1024,
    2 * 1024 * 1024,
    0
};

const util::MountInfo ServiceResource::UserSettingSaveInfo =
{
    0x8000000000000151,
    2 * 1024 * 1024,
    2 * 1024 * 1024,
    0
};

const util::MountInfo ServiceResource::UserSeriesInfoSaveInfo =
{
    0x8000000000000152,
    2 * 1024 * 1024,
    2 * 1024 * 1024,
    0
};

}}} //namespace nn::olsc::srv

