﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SaveDataTransferVersion2.h>
#include <nn/http/json/http_JsonPath.h>
#include <nn/olsc/srv/adaptor/olsc_AdaptorBase.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace olsc { namespace srv { namespace adaptor {

class PolicyInfoBuilder
{
public:
    static const int MaxPropertyCount = 1;

    PolicyInfoBuilder() NN_NOEXCEPT;
    void Reset() NN_NOEXCEPT;
    bool Validate() NN_NOEXCEPT;
    const PolicyInfo& GetPolicyInfo() const NN_NOEXCEPT;
    template<typename FlagType>
    void SetFlag() NN_NOEXCEPT;

    template<typename FlagType>
    bool IsUnset() const NN_NOEXCEPT;

    void SetPolicyType(PolicyType type) NN_NOEXCEPT;

private:
    PolicyInfo m_PolicyInfo;
    nn::util::BitFlagSet<MaxPropertyCount> m_Imported;
};

class PolicyInfoAdaptor
    : public AdaptorBase<8, 128>
{
public:
    PolicyInfoAdaptor() NN_NOEXCEPT = default;

    virtual bool UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual bool NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    Result GetPolicyInfo(PolicyInfo* pOutValue) const NN_NOEXCEPT;

    static const int MaxPathLength = 64;

private:
    bool MakeAndCheckObjectPath(char* buffer, size_t bufferSize, const JsonPathType& jsonPath) NN_NOEXCEPT;

private:
    PolicyInfoBuilder m_Builder;

    char m_PathBuffer[MaxPathLength];
    int m_PathBufferLength = 0;
    bool m_IsAcceptable = false;
};

}}}} // namespace nn::olsc::srv::adaptor
