﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/am/am_Shim.h>
#include <nn/am/am_Result.h>
#include <nn/oe/oe_TvPowerStateMatchingControl.private.h>


namespace nn { namespace oe {

//-----------------------------------------------------------------------------
//  テレビとの電源連動機能のモード変更
//
void SetTvPowerStateMatchingMode(TvPowerStateMatchingMode mode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(mode == TvPowerStateMatchingMode_Default ||
                    mode == TvPowerStateMatchingMode_Disabled);

    NN_ABORT_UNLESS_RESULT_SUCCESS(am::GetCommonStateGetter()->SetTvPowerStateMatchingMode(mode));
}



//-----------------------------------------------------------------------------

}}  // namespace nn::oe

