﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/oe/oe_SubProgramJump.private.h>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_ApplicationId.h>

#include <nn/applet/applet_SubProgramJump.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace oe {

namespace {

Result SetParameterImpl(applet::StorageHandle* pOut, const void* data, size_t dataSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(dataSize <= 4096);
    NN_ABORT_UNLESS(dataSize <= 4096);
    applet::StorageHandle storageHandle;
    if (dataSize > 0)
    {
        NN_SDK_ASSERT_NOT_NULL(data);
        NN_ABORT_UNLESS_RESULT_SUCCESS(applet::CreateStorage(&storageHandle, dataSize));
        NN_ABORT_UNLESS_RESULT_SUCCESS(applet::WriteToStorage(storageHandle, 0, data, dataSize));
    }
    else
    {
        storageHandle = applet::InvalidStorageHandle;
    }
    *pOut = storageHandle;
    NN_RESULT_SUCCESS;
}

}

Result RestartProgram(const void* data, size_t dataSize) NN_NOEXCEPT
{
    applet::StorageHandle storageHandle;
    NN_RESULT_DO(SetParameterImpl(&storageHandle, data, dataSize));
    return applet::RestartProgram(storageHandle);
}

Result ExecuteProgram(uint8_t programIndex, const void* data, size_t dataSize) NN_NOEXCEPT
{
    applet::StorageHandle storageHandle;
    NN_RESULT_DO(SetParameterImpl(&storageHandle, data, dataSize));
    return applet::ExecuteProgram(programIndex, storageHandle);
}

int GetPreviousProgramIndex() NN_NOEXCEPT
{
    return applet::GetPreviousProgramIndex();
}

Result JumpToSubProgramForDevelopment(nn::ApplicationId applicationId, const void* data, size_t dataSize) NN_NOEXCEPT
{
    applet::StorageHandle storageHandle;
    NN_RESULT_DO(SetParameterImpl(&storageHandle, data, dataSize));
    return applet::JumpToSubApplicationProgramForDevelopment({applicationId.value}, storageHandle);
}

}}
