﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ntc/detail/service/ntc_ServerTimeDownloader.h>

#include <nn/ntc/detail/service/core/ntc_Download.h>
#include <nn/ntc/detail/service/core/ntc_ResponseParser.h>

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

namespace nn { namespace ntc { namespace detail { namespace service {

namespace
{
    //!< 時刻のダウンロード、サーバーレスポンスの解析の一連の処理を行う関数
    nn::Result DownloadServerTime(nn::time::PosixTime* pOutCorrectTime) NN_NOEXCEPT
    {
        const char* RequestUrl = "https://aauth-%.ndas.srv.nintendo.net/v1/time";

        NN_SDK_ASSERT_NOT_NULL(pOutCorrectTime);

        char downloadBuffer[64] = {};
        size_t downloadSize = 0;

        NN_RESULT_DO(core::Download(
            RequestUrl,
            &downloadSize,
            downloadBuffer,
            sizeof(downloadBuffer) - 1)); // NULL 終端できるバッファを残して - 1 をダウンロードサイズ上限とする

        int64_t unixTimeMilliSeconds = 0;
        NN_RESULT_DO(core::ParseTimeDataResponse(&unixTimeMilliSeconds, downloadBuffer, downloadSize + 1));

        // NN_DETAIL_NTC_SERVER_LOG("Network unix time:%lld[ms]\n", unixTimeMilliSeconds);

        const nn::time::PosixTime serverTime = {unixTimeMilliSeconds / 1000LL}; // milli seconds -> seconds

        *pOutCorrectTime = serverTime;
        NN_RESULT_SUCCESS;
    }
}

nn::Result ServerTimeDownloader::DownloadPosixTimeFromServer(
    nn::time::PosixTime* pOut) NN_NOEXCEPT
{
    nn::Result result;
    nn::time::PosixTime serverTime = {};

    // NIFM のネットワーク利用要求はクライアントが出している前提

    // TODO:クライアントが要求を出しているかの確認

    result = DownloadServerTime(&serverTime); // call block function.

    if(result.IsSuccess())
    {
        *pOut = serverTime;
    }
    else
    {
        NN_DETAIL_NTC_SERVER_LOG("Time correction failed. (%08x, %03d-%04d)\n",
            result.GetInnerValueForDebug(),
            result.GetModule(), result.GetDescription());
    }

    NN_RESULT_THROW(result);
}

}}}} // nn::ntc::detail::service
