﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>

namespace nn { namespace ns { namespace srv {
    struct SystemUpdateTaskIdInfo
    {
        nim::SystemUpdateTaskId id;
        nim::SystemUpdateTaskInfo info;
    };
    Result GetSystemUpdateTaskIdInfo(util::optional<SystemUpdateTaskIdInfo>* outValue) NN_NOEXCEPT;
    Result DestroyAllSystemUpdateTask() NN_NOEXCEPT;
    Result CreateOrReuseSystemUpdateTask(nim::SystemUpdateTaskId* outValue, const ncm::ContentMetaKey& latest, bool requiresExFatDriver) NN_NOEXCEPT;
    Result GetLatestSystemUpdateMeta(ncm::ContentMetaKey* outValue, nim::AsyncContentMetaKey* async) NN_NOEXCEPT;
    Result NeedsUpdate(bool* outValue, const ncm::ContentMetaKey& latest, bool requiresExFat) NN_NOEXCEPT;
    Result NeedsUpdateVulnerability(bool* outValue, const ncm::ContentMetaKey& latest) NN_NOEXCEPT;

    util::optional<ncm::ContentMetaKey> GetSystemUpdateMetaKey() NN_NOEXCEPT;
    uint32_t GetSystemUpdateVersion() NN_NOEXCEPT;
}}}
