﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/srv/ns_ServiceGetterInterfaceServer.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/ns/ns_DevelopApi.h>
#include <nn/pm/pm_ShellApi.h>
#include <nn/ns/srv/ns_Shell.h>
#include <nn/ns/ns_Result.h>

#include <nn/ns/srv/ns_ApplicationManagerInterfaceServer.h>

namespace nn { namespace ns { namespace srv {
    namespace
    {
        Result CheckCapability(Bit32 require, Bit32 has) NN_NOEXCEPT
        {
            NN_RESULT_THROW_UNLESS((require & has) == require, ns::ResultNotPermittedPort());
            NN_RESULT_SUCCESS;
        }
    }

    ServiceGetterInterfaceServer::ServiceGetterInterfaceServer(srv::ApplicationManagerInterfaceServer* impl, Bit32 capability) NN_NOEXCEPT : m_Impl(impl), m_Capability(capability)
    {
    }

    Result ServiceGetterInterfaceServer::GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::DownloadTask, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IDownloadTaskInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }
    Result ServiceGetterInterfaceServer::GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ContentManagement, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IContentManagementInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::DocumentAccess, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IDocumentInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ApplicationManager, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IApplicationManagerInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::AccountProxyForCreation, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IAccountProxyInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::FactoryReset, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IFactoryResetInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ApplicationVersion, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IApplicationVersionInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ECommerce, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IECommerceInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ReadOnlyApplicationRecord, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IReadOnlyApplicationRecordInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::ReadOnlyApplicationControlData, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IReadOnlyApplicationControlDataInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }

    Result ServiceGetterInterfaceServer::GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT
    {
        NN_RESULT_DO(CheckCapability(Capability::DynamicRights, m_Capability));
        *outValue = sf::CreateSharedObjectWithoutManagement<nn::ns::detail::IDynamicRightsInterface, srv::ApplicationManagerInterfaceServer>(m_Impl);

        NN_RESULT_SUCCESS;
    }
}}}

