﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_PreInstallManager.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

#include "ns_AsyncPreInstallImpl.h"

namespace nn { namespace ns { namespace srv {
namespace {
    typedef sf::ObjectFactory<sf::impl::StaticOneAllocationPolicy> StaticOneFactory;

    Result RequestCleanupPreInstalledApplicationImpl(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ApplicationRecordDatabase* pDb, util::optional<ncm::ApplicationId> appId) NN_NOEXCEPT
    {
        auto emplacedRef = StaticOneFactory::CreateSharedEmplaced<ns::detail::IAsyncResult, AsyncCleanupPreInstalledApplicationImpl>(pDb, appId);
        NN_RESULT_THROW_UNLESS(emplacedRef, ResultOutOfMaxRunningTask());

        NN_RESULT_DO(emplacedRef.GetImpl().Run());

        *outHandle = sf::NativeHandle(emplacedRef.GetImpl().GetEvent().GetReadableHandle(), false);
        *outAsync = emplacedRef;

        NN_RESULT_SUCCESS;
    }
}

    Result PreInstallManager::RequestCleanupAllPreInstalledApplications(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    {
        return RequestCleanupPreInstalledApplicationImpl(outHandle, outAsync, m_pRecordDb, util::nullopt);
    }

    Result PreInstallManager::RequestCleanupPreInstalledApplication(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId appId) NN_NOEXCEPT
    {
        return RequestCleanupPreInstalledApplicationImpl(outHandle, outAsync, m_pRecordDb, appId);
    }
}}}
