﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/srv/ns_OsUtil.h>

namespace nn { namespace ns { namespace srv {
    MultiWaitSystemEvent::MultiWaitSystemEvent() NN_NOEXCEPT : m_Count()
    {
        os::InitializeMultiWait(&m_MultiWait);
    }

    int MultiWaitSystemEvent::Link(os::SystemEvent* event) NN_NOEXCEPT
    {
        NN_SDK_ASSERT(m_Count < MaxWaitHolderCount);

        os::InitializeMultiWaitHolder(&m_MultiWaitHolder[m_Count], event->GetBase());
        os::LinkMultiWaitHolder(&m_MultiWait, &m_MultiWaitHolder[m_Count]);

        int outIndex = m_Count;
        m_Count++;

        return outIndex;
    }

    int MultiWaitSystemEvent::WaitAny() NN_NOEXCEPT
    {
        auto signaled = os::WaitAny(&m_MultiWait);
        for (int i = 0; i < m_Count; i++)
        {
            if (&m_MultiWaitHolder[i] == signaled)
            {
                return i;
            }
        }

        NN_ABORT("must not come here");
    }
}}}
