﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nim/nim_Result.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/detail/ns_Log.h>
#include <nn/ns/srv/ns_DownloadTaskListManager.h>
#include <nn/result/result_HandlingUtility.h>
#include "ns_AsyncEnsureDownloadTaskImpl.h"

namespace nn { namespace ns { namespace srv {
    Result AsyncEnsureDownloadTaskImpl::GetImpl() NN_NOEXCEPT
    {
        NN_RESULT_TRY(GetAndSaveErrorContext(m_AsyncDownloadTaskData))
            NN_RESULT_CATCH(nim::ResultDownloadTaskListNotFound)
            {
                NN_DETAIL_NS_TRACE("[AsyncEnsureDownloadTaskImpl] Download task list not found\n");
                NN_RESULT_SUCCESS;
            }
            NN_RESULT_CATCH(nim::ResultDownloadTaskListIsLatest)
            {
                NN_DETAIL_NS_TRACE("[AsyncEnsureDownloadTaskImpl] Download task list is latest\n");
                NN_RESULT_SUCCESS;
            }
            NN_RESULT_CATCH_CONVERT(
                nim::ResultSystemUpdateRequiredForContentDelivery,
                ns::ResultSystemUpdateRequiredForContentDelivery())
        NN_RESULT_END_TRY

        return m_DtlManager->Push(&m_AsyncDownloadTaskData);
    }

    Result AsyncDownloadTaskListDataImpl::GetImpl(const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    {
        NN_RESULT_DO(GetAndSaveErrorContext(m_AsyncDownloadTaskData));
        size_t size;
        NN_RESULT_DO(m_AsyncDownloadTaskData.Read(&size, 0, buffer.GetPointerUnsafe(), buffer.GetSize()));
        NN_RESULT_SUCCESS;
    }

}}}
