﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_Optional.h>

#include "ns_AsyncImpl.h"
#include "ns_AsyncThreadAllocator.h"

namespace nn { namespace ns { namespace srv {
    // TORIAEZU
    static const int MaxContentMetaKeyForContentDelivery = 18; // 2 * 9 = (app & patch) * (親機 + 子機 * 8)

    class AsyncReceiveApplicationImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        virtual ~AsyncReceiveApplicationImpl() NN_NOEXCEPT;

        Result Initialize(ncm::ApplicationId appId, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey keyList[], int numKey, ncm::StorageId storageId) NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

        void CreateErrorContext(err::ErrorContext* pContext, Result result) NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;

        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        bool IsCanceled() const NN_NOEXCEPT;

        Result m_Result{};
        ManualClearSystemEvent m_Event;
        mutable NonRecursiveMutex m_CancelMutex;
        bool m_IsCanceled{};
        util::optional<nim::AsyncResult> m_AsyncResult;
        util::optional<ThreadInfo> m_ThreadInfo;

        ncm::ApplicationId m_AppId;
        uint32_t m_Ip{};
        uint16_t m_Port{};
        ncm::ContentMetaKey m_KeyList[MaxContentMetaKeyForContentDelivery];
        int m_KeyCount{};
        ncm::StorageId m_StorageId;

    };

    class AsyncSendApplicationImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        virtual ~AsyncSendApplicationImpl() NN_NOEXCEPT;

        Result Initialize(ncm::ApplicationId id, uint32_t ipv4, uint16_t port) NN_NOEXCEPT;

        Result Add(const ncm::StorageContentMetaKey keyList[], int numKey) NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

        void CreateErrorContext(err::ErrorContext* pContext, Result result) NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;

        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        bool IsCanceled() const NN_NOEXCEPT;

        Result m_Result{};
        ManualClearSystemEvent m_Event;
        mutable NonRecursiveMutex m_CancelMutex;
        bool m_IsCanceled{};
        util::optional<nim::AsyncResult> m_AsyncResult;
        util::optional<ThreadInfo> m_ThreadInfo;

        ncm::ApplicationId m_AppId;
        uint32_t m_Ip{};
        uint16_t m_Port{};
        // TORIAEZU
        ncm::StorageContentMetaKey m_KeyList[MaxContentMetaKeyForContentDelivery];
        int m_KeyCount{};
    };

    class AsyncReceiveSystemUpdateImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        AsyncReceiveSystemUpdateImpl(RequestServer::ManagedStop&& stop, bool isExFatDriverDownloaded, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT : m_Stop(std::move(stop)), m_IsCanceled(), m_IsExFatDriverDownloaded(isExFatDriverDownloaded), m_Ip(ipv4), m_Port(port), m_Key(key) {}
        virtual ~AsyncReceiveSystemUpdateImpl() NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

        void CreateErrorContext(err::ErrorContext* pContext, Result result) NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;

        Result m_Result;
        ManualClearSystemEvent m_Event;
        util::optional<nim::AsyncResult> m_AsyncResult;
        NonRecursiveMutex m_CancelMutex;
        RequestServer::ManagedStop m_Stop;
        bool m_IsCanceled;
        bool m_IsExFatDriverDownloaded;
        util::optional<ThreadInfo> m_ThreadInfo;
        uint32_t m_Ip;
        uint16_t m_Port;
        ncm::ContentMetaKey m_Key;
    };

    class AsyncSendSystemUpdateImpl : public AsyncResultBase, private ErrorContextHolder
    {
    public:
        AsyncSendSystemUpdateImpl(RequestServer::ManagedStop&& stop, uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key) NN_NOEXCEPT : m_Stop(std::move(stop)), m_IsCanceled(), m_Ip(ipv4), m_Port(port), m_Key(key) {}
        virtual ~AsyncSendSystemUpdateImpl() NN_NOEXCEPT;

        Result Run() NN_NOEXCEPT;

        os::SystemEvent& GetEvent() NN_NOEXCEPT
        {
            return m_Event;
        }

        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            *outValue = ErrorContextHolder::GetErrorContextImpl();
            NN_RESULT_SUCCESS;
        }

        void CreateErrorContext(err::ErrorContext* pContext, Result result) NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;
        virtual void CancelImpl() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetImpl() NN_NOEXCEPT NN_OVERRIDE;

        Result m_Result;
        ManualClearSystemEvent m_Event;
        util::optional<nim::AsyncResult> m_AsyncResult;
        NonRecursiveMutex m_CancelMutex;
        RequestServer::ManagedStop m_Stop;
        bool m_IsCanceled;
        util::optional<ThreadInfo> m_ThreadInfo;
        uint32_t m_Ip;
        uint16_t m_Port;
        ncm::ContentMetaKey m_Key;
    };

}}}

