﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_Language.h>
#include <nn/util/util_Optional.h>
#include <cstring>

#include "ns_ApplicationLanguage.h"

namespace nn { namespace ns { namespace srv {
namespace {
ns::detail::ApplicationLanguage AmericanEnglishPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage LatinAmericanSpanishPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage CanadianFrenchPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage BritishEnglishPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage FrenchPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage GermanPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage SpanishPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage ItalianPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage DutchPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage PortuguesePriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage RussianPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage JapanesePriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage SimplifiedChinesePriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage TraditionalChinesePriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::TraditionalChinese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Korean,
};

ns::detail::ApplicationLanguage KoreanPriorityList[LanguagePriorityListLength] =
{
    ns::detail::ApplicationLanguage::Korean,
    ns::detail::ApplicationLanguage::AmericanEnglish,
    ns::detail::ApplicationLanguage::BritishEnglish,
    ns::detail::ApplicationLanguage::LatinAmericanSpanish,
    ns::detail::ApplicationLanguage::CanadianFrench,
    ns::detail::ApplicationLanguage::French,
    ns::detail::ApplicationLanguage::German,
    ns::detail::ApplicationLanguage::Spanish,
    ns::detail::ApplicationLanguage::Italian,
    ns::detail::ApplicationLanguage::Dutch,
    ns::detail::ApplicationLanguage::Portuguese,
    ns::detail::ApplicationLanguage::Russian,
    ns::detail::ApplicationLanguage::Japanese,
    ns::detail::ApplicationLanguage::SimplifiedChinese,
    ns::detail::ApplicationLanguage::TraditionalChinese,
};

const char* ApplicationLanguageCodeString[static_cast<int>(ns::detail::ApplicationLanguage::Max)] =
{
    "en-US",        //!< Language_AmericanEnglish
    "en-GB",        //!< Language_BritishEnglish
    "ja",           //!< Language_Japanese
    "fr",           //!< Language_French
    "de",           //!< Language_German
    "es-419",       //!< Language_LatinAmericanSpanish
    "es",           //!< Language_Spanish
    "it",           //!< Language_Italian
    "nl",           //!< Language_Dutch
    "fr-CA",        //!< Language_CanadianFrench
    "pt",           //!< Language_Portuguese
    "ru",           //!< Language_Russian
    "ko",           //!< Language_Korean
    "zh-Hant",      //!< Language_TraditionalChinese
    "zh-Hans",      //!< Language_SimplifiedChinese
};

const char* ApplicationLanguageStringList[] =
{
    "AmericanEnglish",
    "BritishEnglish",
    "Japanese",
    "French",
    "German",
    "LatinAmericanSpanish",
    "Spanish",
    "Italian",
    "Dutch",
    "CanadianFrench",
    "Portuguese",
    "Russian",
    "Korean",
    "TraditionalChinese",
    "SimplifiedChinese"
};

}

const ns::detail::ApplicationLanguage* GetLanguagePriorityList(ns::detail::ApplicationLanguage language) NN_NOEXCEPT
{
    if( language == ns::detail::ApplicationLanguage::Japanese )             return JapanesePriorityList;
    if( language == ns::detail::ApplicationLanguage::AmericanEnglish )      return AmericanEnglishPriorityList;
    if( language == ns::detail::ApplicationLanguage::French )               return FrenchPriorityList;
    if( language == ns::detail::ApplicationLanguage::German )               return GermanPriorityList;
    if( language == ns::detail::ApplicationLanguage::Italian )              return ItalianPriorityList;
    if( language == ns::detail::ApplicationLanguage::Spanish )              return SpanishPriorityList;
    if( language == ns::detail::ApplicationLanguage::Dutch )                return DutchPriorityList;
    if( language == ns::detail::ApplicationLanguage::Portuguese )           return PortuguesePriorityList;
    if( language == ns::detail::ApplicationLanguage::Russian )              return RussianPriorityList;
    if( language == ns::detail::ApplicationLanguage::BritishEnglish )       return BritishEnglishPriorityList;
    if( language == ns::detail::ApplicationLanguage::CanadianFrench )       return CanadianFrenchPriorityList;
    if( language == ns::detail::ApplicationLanguage::LatinAmericanSpanish ) return LatinAmericanSpanishPriorityList;
    if( language == ns::detail::ApplicationLanguage::SimplifiedChinese )    return SimplifiedChinesePriorityList;
    if( language == ns::detail::ApplicationLanguage::Korean )               return KoreanPriorityList;
    if( language == ns::detail::ApplicationLanguage::TraditionalChinese )   return TraditionalChinesePriorityList;

    return nullptr;
}

util::optional<ns::detail::ApplicationLanguage> ToApplicationLanguage(const settings::LanguageCode& language) NN_NOEXCEPT
{
    for (int i = 0; i < static_cast<int>(ns::detail::ApplicationLanguage::Max); i++)
    {
        if (std::strcmp(language.string, ApplicationLanguageCodeString[i]) == 0)
        {
            return static_cast<ns::detail::ApplicationLanguage>(i);
        }
    }

    return util::nullopt;
}

util::optional<settings::LanguageCode> MakeLanguageCode(ns::detail::ApplicationLanguage language) NN_NOEXCEPT
{
    if (language == ns::detail::ApplicationLanguage::AmericanEnglish)               return settings::LanguageCode::Make(settings::Language::Language_AmericanEnglish);
    if (language == ns::detail::ApplicationLanguage::BritishEnglish)                return settings::LanguageCode::Make(settings::Language::Language_BritishEnglish);
    if (language == ns::detail::ApplicationLanguage::Japanese)                      return settings::LanguageCode::Make(settings::Language::Language_Japanese);
    if (language == ns::detail::ApplicationLanguage::French)                        return settings::LanguageCode::Make(settings::Language::Language_French);
    if (language == ns::detail::ApplicationLanguage::German)                        return settings::LanguageCode::Make(settings::Language::Language_German);
    if (language == ns::detail::ApplicationLanguage::LatinAmericanSpanish)          return settings::LanguageCode::Make(settings::Language::Language_LatinAmericanSpanish);
    if (language == ns::detail::ApplicationLanguage::Spanish)                       return settings::LanguageCode::Make(settings::Language::Language_Spanish);
    if (language == ns::detail::ApplicationLanguage::Italian)                       return settings::LanguageCode::Make(settings::Language::Language_Italian);
    if (language == ns::detail::ApplicationLanguage::Dutch)                         return settings::LanguageCode::Make(settings::Language::Language_Dutch);
    if (language == ns::detail::ApplicationLanguage::CanadianFrench)                return settings::LanguageCode::Make(settings::Language::Language_CanadianFrench);
    if (language == ns::detail::ApplicationLanguage::Portuguese)                    return settings::LanguageCode::Make(settings::Language::Language_Portuguese);
    if (language == ns::detail::ApplicationLanguage::Russian)                       return settings::LanguageCode::Make(settings::Language::Language_Russian);
    if (language == ns::detail::ApplicationLanguage::Korean)                        return settings::LanguageCode::Make(settings::Language::Language_Korean);
    if (language == ns::detail::ApplicationLanguage::TraditionalChinese)            return settings::LanguageCode::Make(settings::Language::Language_TraditionalChinese);
    if (language == ns::detail::ApplicationLanguage::SimplifiedChinese)             return settings::LanguageCode::Make(settings::Language::Language_SimplifiedChinese);

    return util::nullopt;
}
const char* GetApplicationLanguageString(ns::detail::ApplicationLanguage language) NN_NOEXCEPT
{
    return ApplicationLanguageStringList[static_cast<int>(language)];
}

}}} // namespace nn::ns::srv
