﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ns/ns_ApplicationManagerApi.h>

namespace nn { namespace ns { namespace srv {
    Result ReadApplicationControlData(size_t* outValue, void* buffer, size_t bufferSize, ncm::ApplicationId applicationId, uint8_t programIndex, const char* path, settings::LanguageCode language) NN_NOEXCEPT;
    Result ReadApplicationControlProperty(ApplicationControlProperty* pOut, ncm::ApplicationId applicationId, uint8_t programIndex, const char* path) NN_NOEXCEPT;
}}}
