﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationApplyDeltaTask
    {
    public:
        typedef ApplicationApplyDeltaProgress TypeProgress;
        typedef ApplicationApplyDeltaState TypeState;

    public:
        explicit ApplicationApplyDeltaTask(ncm::ApplicationId appId) NN_NOEXCEPT;
        explicit ApplicationApplyDeltaTask(nim::ApplyDeltaTaskId id) NN_NOEXCEPT;

        bool IsValid() const NN_NOEXCEPT
        {
            return m_IsValid;
        }

        Result StartApplyDeltaTask() NN_NOEXCEPT;
        Result GetProgress(ApplicationApplyDeltaProgress* outValue) NN_NOEXCEPT;

        Result IsCommittable(bool* outValue) NN_NOEXCEPT;
        Result Commit() NN_NOEXCEPT;
        Result ListKey(int* outCount, ncm::StorageContentMetaKey outList[], int count, int offset) NN_NOEXCEPT;

        Result NeedsCleanup(bool* outValue) NN_NOEXCEPT;
        Result Destroy() NN_NOEXCEPT;
        Result Resume() NN_NOEXCEPT;
        Result CalculateRequiredSize(int64_t* outValue) NN_NOEXCEPT;
        Result GetRequiredStorage(ncm::StorageId* outValue) NN_NOEXCEPT;

        // 処理を進められる状態かどうか
        Result NeedsProcess(bool* outValue) NN_NOEXCEPT;
        // Request するべき状態かどうか
        // すでに処理中の場合は、NeedsProcess だが NeedsRequestToRun ではない
        Result NeedsRequestToRun(bool* outValue) NN_NOEXCEPT;

        Result CalculateOccupiedSize(int64_t* outValue, ncm::StorageId storageId) NN_NOEXCEPT;

        static Result ResumeAll() NN_NOEXCEPT;

    private:
        bool m_IsValid;
        nim::ApplyDeltaTaskId m_Id;
    };
}}}

