﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nsd/detail/nsd_Shim.h>
#include <nn/nsd/nsd_ApiForMenu.h>
#include <nn/nsd/detail/nsd_DetailApiForMenu.h>
#include <nn/nsd/detail/nsd_StaticMutex.h>
#include <nn/nsd/nsd_TypesPrivate.h>

#include <nn/nn_Abort.h>
#include <mutex>

// WorkBufferSizeForImportSettings は
// JWT のパース結果を入れるバッファと、現状のセーブデータを read して更新されているかの確認を行うバッファが必要なので、
// sizeof(SaveData) x 2 以上である必要がある.
NN_STATIC_ASSERT(nn::nsd::WorkBufferSizeForImportSettings >= sizeof(nn::nsd::SaveData) * 2);

namespace nn { namespace nsd {

    nn::Result GetSettingName(SettingName* pOut) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_NOT_NULL(pOut);
        return nn::nsd::detail::ipc::GetSettingName( pOut );
    }

    void GetEnvironmentIdentifier(EnvironmentIdentifier* pOut) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_NOT_NULL(pOut);
        nn::nsd::detail::ipc::GetEnvironmentIdentifier( pOut );
    }

    void DeleteSettings(DeleteMode deleteMode) NN_NOEXCEPT
    {
        nn::nsd::detail::ipc::DeleteSettings( deleteMode );
    }

    nn::Result ImportSettings(
        const void* pBuffer, size_t bufferSize,
        void* pWorkBuffer, size_t workBufferSize,
        ImportMode importMode) NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_NOT_NULL(pBuffer);
        NN_ABORT_UNLESS_NOT_NULL(pWorkBuffer);
        NN_ABORT_UNLESS_GREATER_EQUAL(workBufferSize, WorkBufferSizeForImportSettings);

        return nn::nsd::detail::ipc::ImportSettings( pBuffer, bufferSize, pWorkBuffer, workBufferSize, importMode );
    }

    void DisableChangeEnvironmentIdentifier() NN_NOEXCEPT
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::nsd::detail::ipc::SetChangeEnvironmentIdentifierDisabled(true));
    }

}} // nn::nsd
