﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_TerminateResultApi.h>
#include <nn/ns/ns_TerminateResultSystemApi.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    Result SetApplicationTerminateResult(ncm::ApplicationId id, Result result) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->SetApplicationTerminateResult(id, result.GetInnerValueForDebug());
    }

    Result ClearApplicationTerminateResult(ncm::ApplicationId id) NN_NOEXCEPT
    {
        return GetApplicationManagerInterface()->ClearApplicationTerminateResult(id);
    }

    Result GetApplicationTerminateResult(Result* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        uint32_t innerValue;
        NN_RESULT_DO(GetApplicationManagerInterface()->GetApplicationTerminateResult(&innerValue, id));
        *outValue = result::detail::ConstructResult(innerValue);
        NN_RESULT_SUCCESS;
    }

    Result GetRawApplicationTerminateResult(Result* outValue, ncm::ApplicationId id) NN_NOEXCEPT
    {
        uint32_t innerValue;
        NN_RESULT_DO(GetApplicationManagerInterface()->GetRawApplicationTerminateResult(&innerValue, id));
        *outValue = result::detail::ConstructResult(innerValue);
        NN_RESULT_SUCCESS;
    }
}}
