﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ns/ns_NotificationSystemApi.h>
#include "ns_Initialize.h"

namespace nn { namespace ns {
    bool IsNotificationSetupCompleted() NN_NOEXCEPT
    {
        bool isCompleted;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->IsNotificationSetupCompleted(&isCompleted));
        return isCompleted;
    }

    int64_t GetLastNotificationInfoCount() NN_NOEXCEPT
    {
        int64_t count;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->GetLastNotificationInfoCount(&count));
        return count;
    }

    int ListLastNotificationInfo(NotificationInfo outList[], int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->ListLastNotificationInfo(&outCount, sf::OutArray<NotificationInfo>(outList, static_cast<size_t>(count))));
        return outCount;
    }

    int ListNotificationTask(AsyncTask outList[], int count) NN_NOEXCEPT
    {
        int outCount;
        NN_ABORT_UNLESS_RESULT_SUCCESS(GetApplicationManagerInterface()->ListNotificationTask(&outCount, sf::OutArray<AsyncTask>(outList, static_cast<size_t>(count))));
        return outCount;
    }
}}

