﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <curl/curl.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/lr/lr_Service.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/socket.h>
#include <nn/ovln/ovln_SenderForOverlay.h>
#include <nn/ovln/ovln_ForDevelop.h>
#include <nn/ns/ns_ApiForDfc.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/ssl/ssl_Result.h>

#if defined NN_BUILD_CONFIG_OS_HORIZON || (defined NN_BUILD_CONFIG_OS_WIN && defined NN_BUILD_CONFIG_ADDRESS_32)
#define NN_NS_SSL_SUPPORTED
#endif

#ifdef NN_NS_SSL_SUPPORTED
#include <nn/ssl.h>
#endif

namespace{
    nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;
}

namespace nn { namespace ns {
    void InitializeDependenciesForDfc() NN_NOEXCEPT
    {
        ncm::Initialize();
        lr::Initialize();
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::socket::Initialize(g_SocketConfigWithMemory));
        NN_ABORT_UNLESS_EQUAL(CURLE_OK, curl_global_init(CURL_GLOBAL_ALL));
        NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::InitializeSystem());
        ovln::PrepareSenderAndReceiverForDevelop();
        NN_ABORT_UNLESS_RESULT_SUCCESS(ovln::InitializeSenderLibraryForOverlay());
        nim::InitializeForNetworkInstallManager();

#if !defined(NN_BUILD_CONFIG_OS_WIN)
        NN_ABORT_UNLESS_RESULT_SUCCESS(npns::InitializeForSystem());
#endif
    }

    void FinalizeDependenciesForDfc() NN_NOEXCEPT
    {
#if !defined(NN_BUILD_CONFIG_OS_WIN)
        npns::FinalizeForSystem();
#endif
        nim::FinalizeForNetworkInstallManager();
        ovln::FinalizeSenderLibraryForOverlay();
        ovln::ReleasePreparedSenderAndReceiverForDevelop();
        curl_global_cleanup();
        NN_ABORT_UNLESS_RESULT_SUCCESS(socket::Finalize());
        lr::Finalize();
        ncm::Finalize();
    }
}}
