﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <memory>

#include <nn/es.h>
#include <nn/fs/fs_FileSystem.h>
#include <nn/fs/fs_Result.h>
#include <nn/ncm/ncm_ContentMetaExtendedData.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMetaUtil.h>
#include <nn/ncm/ncm_Service.h>
#include <nn/ncm/ncm_StorageUtil.h>
#include <nn/nim/nim_Result.h>
#include <nn/nim/srv/nim_LocalCommunicationReceiveSystemUpdateTask.h>
#include <nn/nim/detail/nim_Log.h>
#include <nn/ovln/format/ovln_DownloadMessage.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/util/util_ScopeExit.h>

#include "nim_ResultMappingUtil.h"

namespace nn { namespace nim { namespace srv {
    Result LocalCommunicationReceiveSystemUpdateTask::Initialize(uint32_t ipv4, uint16_t port, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT
    {
        NN_RESULT_DO(m_Data.Initialize(dataFilePath));
        m_Key = key;
        NN_RESULT_DO(LocalCommunicationReceiveContentTaskBase::Initialize(ipv4, port, ncm::StorageId::BuiltInSystem, &m_Data, config));

        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationReceiveSystemUpdateTask::InitializeForCleanup(const ncm::ContentMetaKey& key, Bit32 config, const char *dataFilePath) NN_NOEXCEPT
    {
        NN_UNUSED(key);
        NN_RESULT_DO(m_Data.Initialize(dataFilePath));
        NN_RESULT_DO(LocalCommunicationReceiveContentTaskBase::InitializeForCleanup(ncm::StorageId::BuiltInSystem, &m_Data, config));

        NN_RESULT_SUCCESS;
    }

    int LocalCommunicationReceiveSystemUpdateTask::CountInstallContentMetaKey() NN_NOEXCEPT
    {
        return 1;
    }

    Result LocalCommunicationReceiveSystemUpdateTask::GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT
    {
        NN_UNUSED(index);
        *outValue = m_Key;
        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationReceiveSystemUpdateTask::InstallTicket(const nn::fs::RightsId&, nn::ncm::ContentMetaType) NN_NOEXCEPT
    {
        NN_RESULT_THROW(ResultNotSupported());
    }

    Result LocalCommunicationReceiveSystemUpdateTask::GetReceivedSystemDataPath(ncm::Path* outValue, ncm::SystemDataId id) NN_NOEXCEPT
    {
        NN_RESULT_TRY(GetPreparedPlaceHolderPath(outValue, id.value, ncm::ContentMetaType::SystemData, ncm::ContentType::Data))
            NN_RESULT_CATCH(ncm::ResultPlaceHolderNotFound) { NN_RESULT_THROW(ResultSystemDataNotFound()); }
        NN_RESULT_END_TRY

        NN_RESULT_SUCCESS;
    }

    Result LocalCommunicationReceiveSystemUpdateTask::PrepareDependency() NN_NOEXCEPT
    {
        NN_RESULT_DO(PrepareSystemUpdateDependency());
        NN_RESULT_SUCCESS;
    }

}}}
