﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nim_DynamicRightsCommon.h"

namespace nn { namespace nim { namespace srv {

namespace DynamicRights {

/**
 * @brief   nim::RequestAssignELicenses 用 Async ハンドル
 */
class AsyncAssignELicensesImpl : public AsyncResultImpl<AsyncAssignELicensesImpl>, public DragonsAccessAsyncImpl
{
private:
    typedef AsyncResultImpl<AsyncAssignELicensesImpl>   AsyncBase;
    typedef DragonsAccessAsyncImpl                      Executor;
    typedef uint16_t                                    CountType;

public:
    AsyncAssignELicensesImpl() NN_NOEXCEPT;
    ~AsyncAssignELicensesImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const ::nn::account::Uid& uid, const ::nn::sf::InArray<::nn::es::RightsId>& rightsIds, const ELicenseType& licenseType, const char* pTemporaryFilePath) NN_NOEXCEPT;
    Result GetSize(::nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    Result Read(::nn::sf::Out<std::uint64_t> outValue, int64_t offset, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

    //! @brief  未使用
    Result GetETag(::nn::sf::Out<::nn::nim::ETag>) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

protected:
    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

private:
    TemporaryFileStore              m_ValueStore;
    ::nn::account::Uid              m_User;
    HeapUtil::OnetimeHeapSession    m_Post;
    ELicenseType                    m_LicenseType;
    CountType                       m_Count;
};


/**
 * @brief   nim::RequestAssignAllDeviceLinkedELicenses 用 Async ハンドル
 */
class AsyncAssignAllDeviceLinkedELicensesImpl : public AsyncResultImpl<AsyncAssignAllDeviceLinkedELicensesImpl>, public DragonsAccessAsyncImpl
{
private:
    typedef AsyncResultImpl<AsyncAssignAllDeviceLinkedELicensesImpl>    AsyncBase;
    typedef DragonsAccessAsyncImpl                                      Executor;
    typedef uint16_t                                                    CountType;

public:
    AsyncAssignAllDeviceLinkedELicensesImpl() NN_NOEXCEPT;
    ~AsyncAssignAllDeviceLinkedELicensesImpl() NN_NOEXCEPT;

    Result Initialize(DeviceContext* pDeviceContext, const char* pTemporaryFilePath) NN_NOEXCEPT;
    Result GetSize(::nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    Result Read(::nn::sf::Out<std::uint64_t> outValue, int64_t offset, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT;

    virtual Result GetErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
    {
        return Executor::GetErrorContext(outValue.GetPointer());
    }

    //! @brief  未使用
    Result GetETag(::nn::sf::Out<::nn::nim::ETag>) NN_NOEXCEPT
    {
        NN_RESULT_SUCCESS;
    }

protected:
    virtual Result OnQueryAccessProfile(AccessProfile* pOut, char* pOutPathUrl, size_t availablePathUrlCapacity) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnSetupRequestBody(ConnectionType* pConnection) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result OnResolveResponse(InputStream* pInputStream) NN_NOEXCEPT NN_OVERRIDE;

private:
    TemporaryFileStore  m_ValueStore;
    CountType           m_Count;
};


}   // ~DynamicRights

}}}
