﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nim/srv/nim_ThreadAllocator.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {
    class AsyncSystemUpdateMetaImpl : public AsyncValueImpl<AsyncSystemUpdateMetaImpl, ncm::ContentMetaKey>
    {
    public:
        AsyncSystemUpdateMetaImpl() NN_NOEXCEPT;
        ~AsyncSystemUpdateMetaImpl() NN_NOEXCEPT
        {
            AsyncValueImpl<AsyncSystemUpdateMetaImpl, ncm::ContentMetaKey>::Join();
        }

        Result Initialize(DeviceContext* deviceContext) NN_NOEXCEPT;
        Result ExecuteAndValue(ncm::ContentMetaKey* outValue) NN_NOEXCEPT;
        Result CancelImpl() NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        Bit64 m_DeviceId;
        HttpConnection m_Connection;
    };
}}}
