﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include "nim_AsyncImpl.h"

namespace nn { namespace nim { namespace srv {

    class AsyncLatestVersionImpl : public AsyncResultImpl<AsyncLatestVersionImpl>
    {
    public:
        AsyncLatestVersionImpl() NN_NOEXCEPT;
        ~AsyncLatestVersionImpl() NN_NOEXCEPT
        {
            AsyncResultImpl<AsyncLatestVersionImpl>::Join();
        }

        Result Initialize(DeviceContext* deviceContext, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result Execute() NN_NOEXCEPT;
        Result Cancel() NN_NOEXCEPT;
        Result GetSize(sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
        Result Get(const sf::OutBuffer& buffer) const NN_NOEXCEPT;
        virtual Result GetErrorContext(sf::Out<err::ErrorContext> outValue) NN_NOEXCEPT NN_OVERRIDE
        {
            m_Connection.GetErrorContext(outValue.GetPointer());
            NN_RESULT_SUCCESS;
        }

    private:
        size_t GetSizeImpl() const NN_NOEXCEPT
        {
            return sizeof(m_LatestKeyList[0]) * m_LatestCount;
        }

        static const int MaxKeyCount = 2048;
        ncm::ApplicationId m_ApplicationId;
        int m_LatestCount;
        ncm::ContentMetaKey m_LatestKeyList[MaxKeyCount];
        HttpConnection m_Connection;
        Bit64 m_DeviceId;
    };
}}}
