﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;

namespace nn.util
{
    [CppRefPath(@"<nn/util/util_Uuid.h>")]
    [ExternalStruct(16, 1)]
    public struct Uuid
    {
    }
}

namespace nn.nifm
{
    [CppRefPath(@"<nn/nifm/nifm_TypesClientManagement.h>")]
    [ExternalStruct(4, 4)]
    [LargeData]
    public struct ClientId
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesIpSetting.h>")]
    [ExternalStruct(194, 2)]
    [LargeData]
    public struct IpSettingData
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesIpSetting.h>")]
    [ExternalStruct(13, 1)]
    public struct IpAddressSetting
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesIpSetting.h>")]
    [ExternalStruct(9, 1)]
    public struct DnsSetting
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesIpSetting.h>")]
    [ExternalStruct(4, 1)]
    public struct IpV4Address
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesRequirement.h>")]
    [ExternalStruct(36, 4)]
    public struct Requirement
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesWirelessSetting.h>")]
    [ExternalStruct(33, 1)]
    public struct Ssid
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesWirelessSetting.h>")]
    [ExternalStruct(65, 1)]
    public struct SharedKey
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesNetworkInterface.h>")]
    [ExternalStruct(6, 1)]
    public struct MacAddress
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesNetworkProfile.h>")]
    [ExternalStruct(16, 1)]
    public struct SsidListVersion
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesRequestPrivate.h>")]
    [ExternalStruct(1040, 4)]
    [LargeData]
    public struct AdditionalInfo
    {
    }

    [CppRefPath(@"<nn/nifm/nifm_TypesTelemetry.h>")]
    [ExternalStruct(1568, 4)]
    [LargeData]
    public struct TelemetryInfo
    {
    }

    namespace detail
    {
        namespace sf
        {
            // 以下、enum を排除した構造体

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            public struct NetworkInterfaceInfo
            {
                public Bit8 type;
                public MacAddress macAddress;
                public bool isAvailable;
            }

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            [LargeData]
            public struct AccessPointDataOld
            {
                public Ssid ssid;
                public MacAddress bssid;
                public int32_t rssi;
                public Bit8 linkLevel;
                public int16_t channel;
                public Bit8 authentication;
                public Bit8 encryption;
                public Bit8 groupEncryption;
            }

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            [LargeData]
            public struct AccessPointData
            {
                public Ssid ssid;
                public MacAddress bssid;
                public int32_t rssi;
                public Bit8 linkLevel;
                public int16_t channel;
                public Bit8 authentication;
                public Bit8 encryption;
                public Bit8 groupEncryption;
                public bool isSupported;
            }

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            [LargeData]
            public struct NetworkProfileData
            {
                public IpSettingData ipSetting;
                public nn.util.Uuid id;
                [FixedArray(64)]
                public Bit8[] name;
                public Bit8 networkProfileType;
                public Bit8 networkInterfaceType;
                public bool isAutoConnect;
                public bool isLargeCapacity;
                public Ssid ssid;
                public bool nonBroadcast;
                public Bit8 authentication;
                public Bit8 encryption;
                public SharedKey sharedKey;
            }

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            [LargeData]
            public struct NetworkProfileBasicInfo
            {
                public nn.util.Uuid id;
                [FixedArray(64)]
                public Bit8[] name;
                public Bit8 networkProfileType;
                public Bit8 networkInterfaceType;
                public Ssid ssid;
                public Bit8 authentication;
                public Bit8 encryption;
            }

            [CppRefPath(@"<nn/nifm/detail/service/nifm_INifmService.sfdl.h>")]
            public struct InternetConnectionStatus
            {
                public Bit8 networkInterfaceType;
                public Bit8 linkLevel;
                public Bit8 internetAvailability;
            }
        }

        public interface IStaticService : IServiceObject
        {
            [MethodId(4)]
            Result CreateGeneralServiceOld(Out<IGeneralService> outIGeneralService);    // 後方互換用

            [MethodId(5)]
            Result CreateGeneralService(Out<IGeneralService> outIGeneralService, [ProcessId] nn.Bit64 processId);
        }

        public interface IGeneralService : IServiceObject
        {
            [MethodId(1)]
            Result GetClientId(Out<ClientId> outClientId);

            [MethodId(2)]
            Result CreateScanRequest(Out<IScanRequest> outRequest);

            [MethodId(4)]
            Result CreateRequest(Out<IRequest> outRequest, int32_t requirementPreset);

            [MethodId(5)]
            Result GetCurrentNetworkProfile(Out<sf.NetworkProfileData> outNetworkProfileData);

            [MethodId(6)]
            Result EnumerateNetworkInterfaces(OutArray<sf.NetworkInterfaceInfo> outNetworkInterfaceInfoArray, Out<int_t> outCount, Bit32 filterFlags);

            [MethodId(7)]
            Result EnumerateNetworkProfiles([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<sf.NetworkProfileBasicInfo> outNetworkProfileBasicInfoArray, Out<int_t> outCount, Bit8 networkProfileType);

            [MethodId(8)]
            Result GetNetworkProfile(Out<sf.NetworkProfileData> outNetworkProfileData, nn.util.Uuid id);

            [MethodId(9)]
            Result SetNetworkProfile(Out<nn.util.Uuid> outId, sf.NetworkProfileData networkProfileData);

            [MethodId(10)]
            Result RemoveNetworkProfile(nn.util.Uuid id);

            [MethodId(11)]
            Result GetScanDataOld([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<sf.AccessPointDataOld> outAccessPointDataArray, Out<int_t> outCount);

            [MethodId(12)]
            Result GetCurrentIpAddress(Out<IpV4Address> outIpAddress);

            [MethodId(13)]
            Result GetCurrentAccessPointOld(Out<sf.AccessPointDataOld> outAccessPointData);

            [MethodId(14)]
            Result CreateTemporaryNetworkProfile(Out<INetworkProfile> outNetworkProfile, Out<nn.util.Uuid> outNetworkProfileId, sf.NetworkProfileData networkProfileData);

            [MethodId(15)]
            Result GetCurrentIpConfigInfo(Out<IpAddressSetting> outIpAddressSetting, Out<DnsSetting> outDnsSetting);

            [MethodId(16)]
            Result SetWirelessCommunicationEnabled(bool isEnabled);

            [MethodId(17)]
            Result IsWirelessCommunicationEnabled(Out<bool> outIsEnabled);

            [MethodId(18)]
            Result GetInternetConnectionStatus(Out<sf.InternetConnectionStatus> outConnectionStatus);

            [MethodId(19)]
            Result SetEthernetCommunicationEnabled(bool isEnabled);

            [MethodId(20)]
            Result IsEthernetCommunicationEnabled(Out<bool> outIsEnabled);
            [MethodId(21)]
            Result IsAnyInternetRequestAccepted(Out<bool>outIsAnyInternetRequestAccepted, ClientId clientId);

            [MethodId(22)]
            Result IsAnyForegroundRequestAccepted(Out<bool> outIsAnyForegroundRequestAccepted);

            [MethodId(23)]
            Result PutToSleep();

            [MethodId(24)]
            Result WakeUp();

            [MethodId(25)]
            Result GetSsidListVersion(Out<SsidListVersion> outSsidListVersion);

            [MethodId(26)]
            Result SetExclusiveClient(ClientId clientId);

            [MethodId(27)]
            Result GetDefaultIpSetting(Out<IpSettingData> outIpSettingData);

            [MethodId(28)]
            Result SetDefaultIpSetting(IpSettingData ipSettingData);

            [MethodId(29)]
            Result SetWirelessCommunicationEnabledForTest(bool isEnabled);

            [MethodId(30)]
            Result SetEthernetCommunicationEnabledForTest(bool isEnabled);

            [MethodId(31)]
            Result GetTelemetorySystemEventReadableHandle(Out<NativeHandle> outSystemEventReadableHandle);

            [MethodId(32)]
            Result GetTelemetryInfo([BufferTransferMode(BufferTransferMode.MapAlias)] Out<TelemetryInfo> outTelemetryInfo);

            [MethodId(33)]
            Result ConfirmSystemAvailability();

            [MethodId(34)]
            Result SetBackgroundRequestEnabled(bool isEnabled);

            [MethodId(35)]
            Result GetScanData([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<sf.AccessPointData> outAccessPointDataArray, Out<int_t> outCount);

            [MethodId(36)]
            Result GetCurrentAccessPoint(Out<sf.AccessPointData> outAccessPointData);

            [MethodId(37)]
            Result Shutdown();

            [MethodId(38)]
            Result GetAllowedChannels([BufferTransferMode(BufferTransferMode.MapAlias)] OutArray<int16_t> outChannelArray, Out<int_t> outCount);
        }

        public interface IRequest : IServiceObject
        {
            [MethodId(0)]
            Result GetRequestState(Out<int32_t> outRequestState);

            [MethodId(1)]
            Result GetResult();

            [MethodId(2)]
            Result GetSystemEventReadableHandles(Out<NativeHandle> outSystemEventReadableHandle1, Out<NativeHandle> outSystemEventReadableHandle2);

            [MethodId(3)]
            Result Cancel();

            [MethodId(4)]
            Result Submit();

            [MethodId(5)]
            Result SetRequirement(Requirement requirement);

            [MethodId(6)]
            Result SetRequirementPreset(int32_t requirementPreset);

            [MethodId(8)]
            Result SetPriority(uint8_t priority);

            [MethodId(9)]
            Result SetNetworkProfileId(nn.util.Uuid uuid);

            [MethodId(10)]
            Result SetRejectable(bool isRejectable);

            [MethodId(11)]
            Result SetConnectionConfirmationOption(int8_t connectionConfirmationOption);

            [MethodId(12)]
            Result SetPersistent(bool isPersistent);

            [MethodId(13)]
            Result SetInstant(bool isInstant);

            [MethodId(14)]
            Result SetSustainable(bool isSustainable, uint8_t priority);

            [MethodId(15)]
            Result SetRawPriority(uint8_t rawPriority);

            [MethodId(16)]
            Result SetGreedy(bool isGreedy);

            [MethodId(17)]
            Result SetSharable(bool isSharable);

            [MethodId(18)]
            Result SetRequirementByRevision(uint32_t revision);

            [MethodId(19)]
            Result GetRequirement(Out<Requirement> outRequirement);

            [MethodId(20)]
            Result GetRevision(Out<uint32_t> outRevision);

            [MethodId(21)]
            Result GetAppletInfo(
                Out<Bit32> outAppletId,
                Out<Bit32> outLibraryAppletmode,
                Out<uint32_t> outSize,
                OutBuffer outBuffer,
                uint32_t colorIndex);

            [MethodId(22)]
            Result GetAdditionalInfo([BufferTransferMode(BufferTransferMode.MapAlias)] Out<AdditionalInfo> outAdditionalInfo, Out<uint32_t> outRevision);

            [MethodId(23)]
            Result SetKeptInSleep(bool isKeptInSleep);

            [MethodId(24)]
            Result RegisterSocketDescriptor(int32_t socketDescriptor);

            [MethodId(25)]
            Result UnregisterSocketDescriptor(int32_t socketDescriptor);
        }

        public interface IScanRequest : IServiceObject
        {
            [MethodId(0)]
            Result Submit();

            [MethodId(1)]
            Result IsProcessing(Out<bool> outIsProcessing);

            [MethodId(2)]
            Result GetResult();

            [MethodId(3)]
            Result GetSystemEventReadableHandle(Out<NativeHandle> outSystemEventReadableHandle);

            [MethodId(4)]
            Result SetChannels(InArray<int16_t> scanChannelArray);
        }

        public interface INetworkProfile : IServiceObject
        {
            [MethodId(0)]
            Result Update(Out<nn.util.Uuid> outNetworkProfileId, sf.NetworkProfileData networkProfileData);

            [MethodId(1)]
            Result PersistOld(Out<nn.util.Uuid> outId, nn.util.Uuid id);

            [MethodId(2)]
            Result Persist(Out<nn.util.Uuid> outId);
        }
    }
}
