﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nnc/nn_Result.h>
#include <nnc/result/result_CConverter.h>

#include <nn/nifm/nifm_ApiProxy.h>
#include <nn/nifm/nifm_TypesProxySetting.h>

#include <nnc/nifm/nifm_ApiProxy.h>
#include <nnc/nifm/nifm_TypesProxySetting.h>

NN_STATIC_ASSERT(sizeof(nnnifmAuthenticationSetting) == sizeof(nn::nifm::AuthenticationSetting));
NN_STATIC_ASSERT(NN_ALIGNOF(nnnifmAuthenticationSetting) == NN_ALIGNOF(nn::nifm::AuthenticationSetting));
NN_STATIC_ASSERT(offsetof(nnnifmAuthenticationSetting, isEnabled) == offsetof(nn::nifm::AuthenticationSetting, isEnabled));
NN_STATIC_ASSERT(offsetof(nnnifmAuthenticationSetting, username) == offsetof(nn::nifm::AuthenticationSetting, username));
NN_STATIC_ASSERT(offsetof(nnnifmAuthenticationSetting, password) == offsetof(nn::nifm::AuthenticationSetting, password));

NN_STATIC_ASSERT(sizeof(nnnifmProxySetting) == sizeof(nn::nifm::ProxySetting));
NN_STATIC_ASSERT(NN_ALIGNOF(nnnifmProxySetting) == NN_ALIGNOF(nn::nifm::ProxySetting));
NN_STATIC_ASSERT(offsetof(nnnifmProxySetting, isEnabled) == offsetof(nn::nifm::ProxySetting, isEnabled));
NN_STATIC_ASSERT(offsetof(nnnifmProxySetting, port) == offsetof(nn::nifm::ProxySetting, port));
NN_STATIC_ASSERT(offsetof(nnnifmProxySetting, proxy) == offsetof(nn::nifm::ProxySetting, proxy));
NN_STATIC_ASSERT(offsetof(nnnifmProxySetting, authentication) == offsetof(nn::nifm::ProxySetting, authentication));

#ifdef __cplusplus
extern "C"
{
#endif

nnResult nnnifmGetCurrentProxySetting( nnnifmProxySetting* pOutProxySetting )
{
    nn::Result result = nn::nifm::GetCurrentProxySetting( reinterpret_cast<nn::nifm::ProxySetting*>(pOutProxySetting) );

    return nn::result::ConvertToC(result);
}

#ifdef __cplusplus
}
#endif
