﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/nifm_TemporaryNetworkProfileClient.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>
#include <nn/nifm/detail/nifm_TypesServiceObjectList.h>

#include <nn/util/util_StringUtil.h>


namespace nn
{
namespace nifm
{
namespace detail
{

nn::Result GetGeneralServicePointer(nn::sf::SharedPointer<detail::IGeneralService>* ppGeneralService) NN_NOEXCEPT;

TemporaryNetworkProfileClient::TemporaryNetworkProfileClient(const NetworkProfileData& networkProfileData) NN_NOEXCEPT
    : m_pINetworkProfile(nullptr),
      m_Id(nn::util::InvalidUuid)
{
    nn::Result result;

    nn::sf::SharedPointer<detail::IGeneralService> pGeneralService;
    result = GetGeneralServicePointer(&pGeneralService);

    NN_SDK_ASSERT(result.IsSuccess());
    if (result.IsFailure())
    {
        return;
    }

    detail::sf::NetworkProfileData profile;
    ConvertNetworkProfileDataToSfFromNifm( &profile, networkProfileData );

    pGeneralService->CreateTemporaryNetworkProfile(&m_pINetworkProfile, &m_Id, profile);
}

TemporaryNetworkProfileClient::~TemporaryNetworkProfileClient() NN_NOEXCEPT
{
}

const nn::util::Uuid& TemporaryNetworkProfileClient::GetId() const NN_NOEXCEPT
{
    return m_Id;
}

Result TemporaryNetworkProfileClient::Update(const NetworkProfileData& networkProfileData) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL( m_pINetworkProfile );

    detail::sf::NetworkProfileData profile;
    ConvertNetworkProfileDataToSfFromNifm( &profile, networkProfileData );

    NN_RESULT_THROW(m_pINetworkProfile->Update(&m_Id, profile));
}

Result TemporaryNetworkProfileClient::Persist() NN_NOEXCEPT
{
    nn::util::Uuid id;

    NN_RESULT_DO(m_pINetworkProfile->Persist(&id));

    m_Id = id;

    NN_RESULT_SUCCESS;
}

}
}
}
