﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/core/accessPoint/nifm_NeighborDetectionAccessPoint.h>

#include <nn/nifm/detail/core/networkInterface/nifm_WirelessInterface.h>


namespace nn
{
namespace nifm
{
namespace detail
{

NeighborDetectionAccessPoint::NeighborDetectionAccessPoint(WirelessInterface* pWirelessInterface) NN_NOEXCEPT
    : AccessPointBase(pWirelessInterface)
{
}

NeighborDetectionAccessPoint::~NeighborDetectionAccessPoint() NN_NOEXCEPT
{
}

nn::Result NeighborDetectionAccessPoint::ConnectImpl(
    const NetworkProfileBase& networkProfile,
    const AggregatedRequestType& aggregatedRequest) const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<WirelessInterface*>(m_pNetworkInterfaceBase)->ConnectImpl(*this, networkProfile, aggregatedRequest));
}

nn::Result NeighborDetectionAccessPoint::DisconnectImpl() const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<WirelessInterface*>(m_pNetworkInterfaceBase)->DisconnectImpl(*this));
}

nn::Result NeighborDetectionAccessPoint::ReleaseImpl() const NN_NOEXCEPT
{
    NN_RESULT_THROW(static_cast<WirelessInterface*>(m_pNetworkInterfaceBase)->ReleaseImpl(*this));
}

void NeighborDetectionAccessPoint::UpdateAccessPoint(
    const NetworkProfileBase& networkProfile) NN_NOEXCEPT
{
    static_cast<WirelessInterface*>(m_pNetworkInterfaceBase)->UpdateAccessPoint(this, networkProfile);
}

AccessPointBase* NeighborDetectionAccessPoint::CopyTo(void* p, size_t size) const NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(p);
    NN_SDK_ASSERT_GREATER_EQUAL(size, sizeof(*this));
    NN_UNUSED(size);

    return new(p) NeighborDetectionAccessPoint(*this);
}

size_t NeighborDetectionAccessPoint::GetSize() const NN_NOEXCEPT
{
    return sizeof(*this);
}

bool NeighborDetectionAccessPoint::operator==(const AccessPointBase& rh) const NN_NOEXCEPT
{
    return rh == *this;
}

}
}
}
