﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ngc.h>

/*!
  @brief NGCライブラリにおいて、挙動をかなり細かくチェックします。動作が遅くなります。
 */
#ifdef NN_BUILD_DEBUG
//#   define NN_NGC_CHECK_VERBOSE
#endif // NN_BUILD_DEBUG
#if defined( NN_NGC_CHECK_VERBOSE ) && defined( NN_SWITCH_DISABLE_ASSERT_WARNING )
#   warning "WARNING : NN_NGC_CHECK_VERBOSE is defined, but assert is disabled."
#endif

/*!
  @brief --gnu-instrumentで計測を行わない関数の属性です。
 */
#ifdef NN_NGC_ENABLE_PROFILER
#   define NN_NGC_NO_INSTRUMENT             __attribute__((no_instrument_function))
#else
#   define NN_NGC_NO_INSTRUMENT
#endif

namespace
{
/*!
  @brief 共通パターンリストです。
 */
const int NgcProfanityFilterPatternListCommon = ( 0 );


/*!
  @brief    システムデータキャッシュの確保用の領域のサイズです。
 */
const int NgcSystemDataCacheSize = (8 * 1024);

/*!
  @brief 共有コンテンツは、単語をチェックすることに最適化された正規表現が格納されています。
         長文でNGワードチェックを行う場合に単語チェックと同様の方法では問題があるため、
         共有コンテンツに格納された情報を読み込んだタイミングで機械的に変換を行います。
         この値は、変換後の正規表現パターンの最大文字数を示します。
 */
const int NgcConvertedPatternLength = ( 256 );

}   // namespace
