﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/oe.h>
#include <nn/ngc/ngc_ProfanityFilterPatternList.h>
#include "ngc_Config.h"

namespace {
    nn::Bit32 GetLanguageSettingPattern(nn::settings::LanguageCode language) NN_NOEXCEPT
    {
        if( language == nn::settings::Language_Japanese)
        {
            return nn::ngc::ProfanityFilterPatternList_Japanese;
        }
        else if( language == nn::settings::Language_AmericanEnglish)
        {
            return nn::ngc::ProfanityFilterPatternList_AmericanEnglish;
        }
        else if( language == nn::settings::Language_French)
        {
            return nn::ngc::ProfanityFilterPatternList_French;
        }
        else if( language == nn::settings::Language_German)
        {
            return nn::ngc::ProfanityFilterPatternList_German;
        }
        else if( language == nn::settings::Language_Italian)
        {
            return nn::ngc::ProfanityFilterPatternList_Italian;
        }
        else if( language == nn::settings::Language_Spanish)
        {
            return nn::ngc::ProfanityFilterPatternList_Spanish;
        }
        else if( language == nn::settings::Language_Chinese)
        {
            return nn::ngc::ProfanityFilterPatternList_SimplifiedChinese;
        }
        else if( language == nn::settings::Language_Korean)
        {
            return nn::ngc::ProfanityFilterPatternList_Korean;
        }
        else if( language == nn::settings::Language_Dutch)
        {
            return nn::ngc::ProfanityFilterPatternList_Dutch;
        }
        else if( language == nn::settings::Language_Portuguese)
        {
            return nn::ngc::ProfanityFilterPatternList_Portuguese;
        }
        else if( language == nn::settings::Language_Russian)
        {
            return nn::ngc::ProfanityFilterPatternList_Russian;
        }
        else if( language == nn::settings::Language_Taiwanese)
        {
            return nn::ngc::ProfanityFilterPatternList_TraditionalChinese;
        }
        else if( language == nn::settings::Language_BritishEnglish)
        {
            return nn::ngc::ProfanityFilterPatternList_BritishEnglish;
        }
        else if( language == nn::settings::Language_CanadianFrench)
        {
            return nn::ngc::ProfanityFilterPatternList_CanadianFrench;
        }
        else if( language == nn::settings::Language_LatinAmericanSpanish)
        {
            return nn::ngc::ProfanityFilterPatternList_LatinAmericanSpanish;
        }
        else if (language == nn::settings::Language_SimplifiedChinese)
        {
            return nn::ngc::ProfanityFilterPatternList_SimplifiedChinese;
        }
        else if (language == nn::settings::Language_TraditionalChinese)
        {
            return nn::ngc::ProfanityFilterPatternList_TraditionalChinese;
        }

        return 0;
    }
}

namespace nn
{
namespace ngc
{
namespace detail
{

/*!--------------------------------------------------------------------------*
  Name:         GetLanguageSetting

  @brief        本体とアプリケーションの言語設定に対応するパターンリストを取得します。
  @return       本体とアプリケーションの言語設定に対応するパターンリストを取得しますパターンリストを返します。
                対応するパターンリストが見つからない場合は0が返ります。
 *---------------------------------------------------------------------------*/
Bit32 GetLanguageSetting(bool checkDesiredLanguage) NN_NOEXCEPT
{
    Bit32 pattern = 0;

    //本体言語設定に対応するパターンリストを取得します。
    nn::settings::LanguageCode language;
    nn::settings::GetLanguageCode(&language);
    pattern |= GetLanguageSettingPattern(language);

#if !defined( NN_BUILD_CONFIG_OS_WIN )
    //アプリケーションが対応する最も優先度の高い言語に対応するパターンリストを取得します。
    if(true == checkDesiredLanguage)
    {
        language = nn::oe::GetDesiredLanguage();
        pattern |= GetLanguageSettingPattern(language);
    }
#else
    NN_UNUSED(checkDesiredLanguage);
#endif // !defined( NN_BUILD_CONFIG_OS_WIN )

    return pattern;
}

}   // namespace detail
}   // namespace ngc
}   // namespace nn

