﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.nfc
{
    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    public struct DeviceHandle
    {
    }

    [ExternalStruct(88, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    [LargeData(true)]
    public struct TagInfo
    {
    }
}

namespace nn.nfp
{
    [ExternalStruct(256, 4)]
    [CppRefPath("<nn/nfp/nfp_Types.h>")]
    [LargeData(true)]
    public struct RegisterInfo
    {
    }

    [ExternalStruct(64, 4)]
    [CppRefPath("<nn/nfp/nfp_Types.h>")]
    [LargeData(true)]
    public struct CommonInfo
    {
    }

    [ExternalStruct(64, 2)]
    [CppRefPath("<nn/nfp/nfp_Types.h>")]
    [LargeData(true)]
    public struct ModelInfo
    {
    }

    [ExternalStruct(64, 8)]
    [CppRefPath("<nn/nfp/nfp_PrivateTypes.h>")]
    [LargeData(true)]
    public struct AdminInfo
    {
    }

    [ExternalStruct(256, 4)]
    [CppRefPath("<nn/nfp/nfp_PrivateTypes.h>")]
    [LargeData(true)]
    public struct RegisterInfoPrivate
    {
    }

    [ExternalStruct(664, 8)]
    [CppRefPath("<nn/nfp/nfp_DebugTypes.h>")]
    [LargeData(true)]
    public struct NfpData
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.hid
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/hid/hid_NpadCommonTypes.h>")]
    public struct NpadIdType
    {
    }
}

namespace nn.xcd
{
    [ExternalStruct(32, 2)]
    [CppRefPath("<nn/xcd/xcd_NfcTypes.h>")]
    public struct McuVersionDataForNfc
    {
    }
}

namespace nn.nfp.detail
{
    public interface IDebug : IServiceObject
    {
        [MethodId(0)]
        Result
            InitializeNfp(
                nn.applet.CheckedAppletResourceUserId aruid,
                [ProcessId] Bit64 pid,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.xcd.McuVersionDataForNfc> mcuVersionData
            );

        [MethodId(1)]
        Result
            FinalizeNfp(
            );

        [MethodId(2)]
        Result
            ListDevicesNfp(
                nn.sf.OutArray<nn.nfc.DeviceHandle> devices,
                nn.sf.Out<int32_t> count
            );

        [MethodId(3)]
        Result
            StartDetectionNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(4)]
        Result
            StopDetectionNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(5)]
        Result
            MountNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 modelType,
                nn.Bit32 mountTarget
            );

        [MethodId(6)]
        Result
            UnmountNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(7)]
        Result
            OpenApplicationAreaNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 accessId
            );

        [MethodId(8)]
        Result
            GetApplicationAreaNfp(
                nn.sf.OutBuffer buffer,
                nn.sf.Out<uint32_t> size,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(9)]
        Result
            SetApplicationAreaNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.sf.InBuffer data
            );

        [MethodId(10)]
        Result
            FlushNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(11)]
        Result
            RestoreNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(12)]
        Result
            CreateApplicationAreaNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 accessId,
                nn.sf.InBuffer initialData
            );

        [MethodId(13)]
        Result
            GetTagInfoNfp(
                Out<nn.nfc.TagInfo> tagInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(14)]
        Result
            GetRegisterInfoNfp(
                Out<nn.nfp.RegisterInfo> registerInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(15)]
        Result
            GetCommonInfoNfp(
                Out<nn.nfp.CommonInfo> commonInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(16)]
        Result
            GetModelInfoNfp(
                Out<nn.nfp.ModelInfo> modelInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(17)]
        Result
            GetActivateEventHandleNfp(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(18)]
        Result
            GetDeactivateEventHandleNfp(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(19)]
        Result
            GetStateNfp(
                Out<nn.Bit32> state
            );

        [MethodId(20)]
        Result
            GetDeviceStateNfp(
                Out<nn.Bit32> state,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(21)]
        Result
            GetNpadIdNfp(
                Out<nn.hid.NpadIdType> npadId,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(22)]
        Result
            GetApplicationAreaSizeNfp(
                nn.sf.Out<uint32_t> size,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(23)]
        Result
            GetAvailabilityChangeEventHandleNfp(
                Out<NativeHandle> handle
            );

        [MethodId(24)]
        Result
            RecreateApplicationAreaNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 accessId,
                nn.sf.InBuffer initialData
            );

        [MethodId(100)]
        Result
            FormatNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(101)]
        Result
            GetAdminInfoNfp(
                Out<nn.nfp.AdminInfo> adminInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(102)]
        Result
            GetRegisterInfoPrivateNfp(
                Out<nn.nfp.RegisterInfoPrivate> registerInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(103)]
        Result
            SetRegisterInfoPrivateNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.nfp.RegisterInfoPrivate registerInfo
            );

        [MethodId(104)]
        Result
            DeleteRegisterInfoNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(105)]
        Result
            DeleteApplicationAreaNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(106)]
        Result
            ExistsApplicationAreaNfp(
                Out<bool> flag,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(200)]
        Result
            GetAllNfp(
                Out<nn.nfp.NfpData> nfpData,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(201)]
        Result
            SetAllNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.nfp.NfpData nfpData
            );

        [MethodId(202)]
        Result
            FlushDebugNfp(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(203)]
        Result
            BreakTagNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 breakType
            );

        [MethodId(204)]
        Result
            ReadBackupDataNfp(
                nn.sf.OutBuffer buffer,
                nn.sf.Out<uint32_t> size
            );

        [MethodId(205)]
        Result
            WriteBackupDataNfp(
                nn.sf.InBuffer data
            );

        [MethodId(206)]
        Result
            WriteNtfNfp(
                nn.nfc.DeviceHandle deviceHandle,
                nn.sf.InBuffer data,
                nn.Bit32 ntfWriteType
            );
    }

    public interface IDebugManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateDebugInterface(
            Out<IDebug> pOutDebugInterface
        );
    }
}
