﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfp/nfp_MiscApi.h>
#include "client/nfp_CommonInterface.h"

namespace nn { namespace nfp {

namespace
{
}

State GetState() NN_NOEXCEPT
{
    nn::Bit32 state;
    if(client::IsCreatedUserInterface() || client::IsCreatedSystemInterface() || client::IsCreatedDebugInterface())
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetState, (&state)));
        return static_cast<State>(state);
    }
    else
    {
        return State_None;
    }
}

DeviceState GetDeviceState(const DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    nn::Bit32 state;
    if(client::IsCreatedUserInterface() || client::IsCreatedSystemInterface() || client::IsCreatedDebugInterface())
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(NN_NFP_CLIENT_GET_COMMON_INTERFACE(GetDeviceState, (&state, reinterpret_cast<const nn::nfc::DeviceHandle&>(deviceHandle))));
        return static_cast<DeviceState>(state);
    }
    else
    {
        return DeviceState_Unexpected;
    }
}

}}
