﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nfp.h>
#include <nn/nfp/nfp_PrivateApi.h>
#include <nn/result/result_HandlingUtility.h>
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#include <nn/applet/applet.h>
#include <nn/la/la_Api.h>
#endif
#include "nfp_AmiiboSettings.h"
#include "nfp_Util.h"
#include "../client/nfp_CommonInterface.h"

namespace nn { namespace nfp { namespace detail {

namespace
{
nn::os::Mutex g_Mutex(false);
nn::nfp::StartParamForAmiiboSettings g_StartParam;
nn::nfp::ReturnValueForAmiiboSettings g_ReturnValue;
}

nn::os::Mutex& RefMutexForAmiiboSettings() NN_NOEXCEPT
{
    return g_Mutex;
}

void GetBufferForAmiiboSettings(nn::nfp::ReturnValueForAmiiboSettings** pOutReturnValue, nn::nfp::StartParamForAmiiboSettings** pOutStartParam) NN_NOEXCEPT
{
    *pOutReturnValue = &g_ReturnValue;
    *pOutStartParam = &g_StartParam;
}

nn::Result StartAmiiboSettings(nn::nfp::ReturnValueForAmiiboSettings* pOutValue, const nn::nfp::StartParamForAmiiboSettings& param) NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    const uint16_t cMajorVersion = 0;
    const uint16_t cMinorVersion = 1;
    nn::la::CommonArgumentsWriter comonArg(cMajorVersion, cMinorVersion);

    size_t out_size;

    nn::Result result = nn::la::StartLibraryAppletEasy(nn::applet::AppletId_LibraryAppletCabinet,
                                                       comonArg,
                                                       &param, sizeof(param),
                                                       pOutValue, sizeof(*pOutValue), &out_size,
                                                       false);
    if(result.IsFailure())
    {
        pOutValue->infoFlags = nn::nfp::AmiiboSettingsInfoFlags_None;
    }

    if(pOutValue->infoFlags == nn::nfp::AmiiboSettingsInfoFlags_None)
    {
        return nn::nfp::ResultNotUpdated();
    }

    NN_RESULT_SUCCESS;
#else
    NN_UNUSED(param);
    pOutValue->infoFlags = nn::nfp::AmiiboSettingsInfoFlags_None;
    return nn::nfp::ResultNotUpdated();
#endif
}

}}}  // namespace nn::nfp::detail
