﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "nfp_UserInterface.h"
#include "nfp_SystemInterface.h"
#include "nfp_DebugInterface.h"

#define NN_NFP_CLIENT_CHECK_COMMON_INTERFACE() \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface() != nullptr: (nn::nfp::client::IsCreatedSystemInterface() ? nn::nfp::client::GetSystemInterface() != nullptr : nn::nfp::client::GetUserInterfaceForCommon() != nullptr))

#define NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_SYSTEM() \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface() != nullptr : nn::nfp::client::GetUserInterface() != nullptr)

#define NN_NFP_CLIENT_CHECK_COMMON_INTERFACE_WITHOUT_USER() \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface() != nullptr : nn::nfp::client::GetSystemInterface() != nullptr)



#define NN_NFP_CLIENT_GET_COMMON_INTERFACE(func, args) \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface()->func##Nfp args : (nn::nfp::client::IsCreatedSystemInterface() ? nn::nfp::client::GetSystemInterface()->func##Nfp args : nn::nfp::client::GetUserInterfaceForCommon()->func##Nfp args))

#define NN_NFP_CLIENT_GET_COMMON_INTERFACE_WITHOUT_SYSTEM(func, args) \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface()->func##Nfp args : nn::nfp::client::GetUserInterface()->func##Nfp args)

#define NN_NFP_CLIENT_GET_COMMON_INTERFACE_WITHOUT_USER(func, args) \
    (nn::nfp::client::IsCreatedDebugInterface() ? nn::nfp::client::GetDebugInterface()->func##Nfp args : nn::nfp::client::GetSystemInterface()->func##Nfp args)

#define NN_NFP_CLIENT_GET_DEBUG_INTERFACE(func, args) \
    (nn::nfp::client::GetDebugInterface()->func##Nfp args)
