﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using Nintendo.ServiceFramework.Applet;
using nn;
using nn.sf;
using std;

namespace nn.nfc
{
    [ExternalStruct(8, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    public struct DeviceHandle
    {
    }

    [ExternalStruct(88, 4)]
    [CppRefPath("<nn/nfc/nfc_Types.h>")]
    [LargeData(true)]
    public struct TagInfo
    {
    }
}

namespace nn.nfc
{
    [ExternalStruct(1, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareKeyId
    {
    }

    [ExternalStruct(24, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareReadBlockData
    {
    }

    [ExternalStruct(24, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareReadBlockParameter
    {
    }

    [ExternalStruct(40, 1)]
    [CppRefPath("<nn/nfc/nfc_MifareTypes.h>")]
    public struct MifareWriteBlockParameter
    {
    }
}

namespace nn.applet
{
    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath(@"<nn/applet/applet_FundamentalTypes.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nn.hid
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/hid/hid_NpadCommonTypes.h>")]
    public struct NpadIdType
    {
    }
}

namespace nn.xcd
{
    [ExternalStruct(32, 2)]
    [CppRefPath("<nn/xcd/xcd_NfcTypes.h>")]
    public struct McuVersionDataForNfc
    {
    }
}

namespace nn
{
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpan
    {
    }
}

namespace nn.nfc.detail
{
    public interface ISystem : IServiceObject
    {
        //0    ~ old:nfc:user
        //100  ~ old:nfc:system
        //200  ~ old:nfp:debug

        //400  ~ nfc:user
        //500  ~ nfc:system
        //600  ~ nfc:debug

        //700  ~ reserved
        //800  ~ reserved
        //900  ~ reserved

        //1000 ~ mifare:user
        //1100 ~ mifare:system
        //1200 ~ mifare:debug

        //1300 ~ pass-through:user
        //1400 ~ pass-through:system
        //1500 ~ pass-through:debug

        ////////////////////////////////
        //0   ~ old:nfc:user
        ////////////////////////////////
        [MethodId(0)]
        Result
            InitializeNfc(
                nn.applet.CheckedAppletResourceUserId aruid,
                [ProcessId] Bit64 pid,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.xcd.McuVersionDataForNfc> mcuVersionData
            );

        [MethodId(1)]
        Result
            FinalizeNfc(
            );

        [MethodId(2)]
        Result
            GetStateNfc(
                Out<nn.Bit32> state
            );

        [MethodId(3)]
        Result
            IsNfcEnabledNfc(
                nn.sf.Out<bool> isNfcEnabled
            );

        ////////////////////////////////
        //100 ~ old:nfc:system
        ////////////////////////////////
        [MethodId(100)]
        Result
            SetNfcEnabledNfc(
                bool isNfcEnabled
            );

        ////////////////////////////////
        //400 ~ nfc:user
        ////////////////////////////////
        [MethodId(400)]
        Result
            Initialize(
                nn.applet.CheckedAppletResourceUserId aruid,
                [ProcessId] Bit64 pid,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.xcd.McuVersionDataForNfc> mcuVersionData
            );

        [MethodId(401)]
        Result
            Finalize(
            );

        [MethodId(402)]
        Result
            GetState(
                Out<nn.Bit32> state
            );

        [MethodId(403)]
        Result
            IsNfcEnabled(
                nn.sf.Out<bool> isNfcEnabled
            );

        [MethodId(404)]
        Result
            ListDevices(
                nn.sf.OutArray<nn.nfc.DeviceHandle> devices,
                nn.sf.Out<int32_t> count
            );

        [MethodId(405)]
        Result
            GetDeviceState(
                Out<nn.Bit32> state,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(406)]
        Result
            GetNpadId(
                Out<nn.hid.NpadIdType> npadId,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(407)]
        Result
            GetAvailabilityChangeEventHandle(
                Out<NativeHandle> handle
            );

        [MethodId(408)]
        Result
            StartDetection(
                nn.nfc.DeviceHandle deviceHandle,
                nn.Bit32 protocolFilter
            );

        [MethodId(409)]
        Result
            StopDetection(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(410)]
        Result
            GetTagInfo(
                Out<nn.nfc.TagInfo> tagInfo,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(411)]
        Result
            GetActivateEventHandle(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(412)]
        Result
            GetDeactivateEventHandle(
                Out<NativeHandle> handle,
                nn.nfc.DeviceHandle deviceHandle
            );

        ////////////////////////////////
        //500 ~ nfc:system
        ////////////////////////////////
        [MethodId(500)]
        Result
            SetNfcEnabled(
                bool isNfcEnabled
            );

        ////////////////////////////////
        //1000  ~ mifare:user
        ////////////////////////////////
        [MethodId(1000)]
        Result
            ReadMifare(
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.OutArray<nn.nfc.MifareReadBlockData> blockData,
                nn.nfc.DeviceHandle deviceHandle,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.nfc.MifareReadBlockParameter> blockParameter
            );

        [MethodId(1001)]
        Result
            WriteMifare(
                nn.nfc.DeviceHandle deviceHandle,
                [BufferTransferMode(BufferTransferMode.MapAlias)] nn.sf.InArray<nn.nfc.MifareWriteBlockParameter> blockParameter
            );

        ////////////////////////////////
        //1300 ~ pass-through:user
        ////////////////////////////////
        [MethodId(1300)]
        Result
            SendCommandByPassThrough(
                nn.sf.OutBuffer buffer,
                nn.sf.Out<uint32_t> size,
                nn.nfc.DeviceHandle deviceHandle,
                nn.sf.InBuffer data,
                nn.TimeSpan timeout
            );

        [MethodId(1301)]
        Result
            KeepPassThroughSession(
                nn.nfc.DeviceHandle deviceHandle
            );

        [MethodId(1302)]
        Result
            ReleasePassThroughSession(
                nn.nfc.DeviceHandle deviceHandle
            );
    }

    public interface ISystemManager : IServiceObject
    {
        [MethodId(0)]
        Result CreateSystemInterface(
            Out<ISystem> pOutSystemInterface
        );
    }
}
