﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_Thread.h>
#include <nn/util/util_BytePtr.h>
#include <nn/nfc/server/util/nfc_ThreadStack.h>

namespace nn { namespace nfc { namespace server { namespace util {

ThreadStack::ThreadStack(size_t size) NN_NOEXCEPT : m_Size(size)
{
    m_Memory = new char [size + nn::os::ThreadStackAlignment];
}

ThreadStack::~ThreadStack() NN_NOEXCEPT
{
    if(m_Memory != nullptr)
    {
        delete [] m_Memory;
        m_Memory = nullptr;
    }
}

void* ThreadStack::Get() NN_NOEXCEPT
{
    return nn::util::BytePtr(m_Memory).AlignUp(nn::os::ThreadStackAlignment).Get();
}

size_t ThreadStack::GetSize() NN_NOEXCEPT
{
    return m_Size;
}

}}}}  // namespace nn::nfc::server::util
