﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>
#include <nn/nfc/server/core/nfc_Result.h>
#include <nn/nfc/server/core/nfc_CoreService.h>
#include <nn/nfc/server/core/nfc_Types.h>
#include <nn/xcd/xcd.h>
#include <nn/xcd/xcd_Result.h>

#define NN_NFC_SERVER_CORE_RETURN(x) return(nn::nfc::server::core::ConvertToNfcResult(x))
#define NN_NFC_SERVER_CORE_RESULT_DO(x) NN_RESULT_DO(nn::nfc::server::core::ConvertToNfcResult(x))

namespace nn { namespace nfc { namespace server { namespace core {

const int XcdRetryCountMax             =  60;
const int XcdSetDataFormatWaitCountMax = 200;
const int XcdSetMcuStateWaitCountMax   = 200;
const int XcdRetryInterval             =  50;

//to Xcd
void ConvertToXcdNfcProtocol(nn::xcd::NfcProtocol* pOutDst, const nn::nfc::NfcProtocol& src) NN_NOEXCEPT;
void ConvertToXcdPollingMask(nn::xcd::NfcPollingMask* pOutDst, const nn::nfc::NfcProtocol& src) NN_NOEXCEPT;
void ConvertToXcdTagType(nn::xcd::NfcTagType* pOutDst, const nn::nfc::TagType& src) NN_NOEXCEPT;
void ConvertToXcdTagId(nn::xcd::NfcTagId* pOutDst, const nn::nfc::TagId& src) NN_NOEXCEPT;
void ConvertToXcdTagInfo(nn::xcd::NfcTagInfo* pOutDst, const nn::nfc::TagInfo& src) NN_NOEXCEPT;
void ConvertToXcdDiscoveryParameter(nn::xcd::NfcDiscoveryParameter* pOutDst, const nn::nfc::server::core::DiscoveryParameter& src) NN_NOEXCEPT;
void ConvertToXcdNtagReadParameter(nn::xcd::NtagReadParameter* pOutDst, const nn::nfc::server::core::NtagReadParameter& src) NN_NOEXCEPT;
void ConvertToXcdNtagWriteParameter(nn::xcd::NtagWriteParameter* pOutDstr, const nn::nfc::server::core::NtagWriteParameter& src) NN_NOEXCEPT;
void ConvertToXcdPassThruParameter(nn::xcd::NfcPassThruParameter* pOutDst, const nn::nfc::server::core::PassThruParameter& src) NN_NOEXCEPT;
void ConvertToXcdMifareReadParameter(nn::xcd::MifareReadParameter* pOutDst, const nn::nfc::server::core::MifareReadParameter& src) NN_NOEXCEPT;
void ConvertToXcdMifareWriteParameter(nn::xcd::MifareWriteParameter* pOutDst, const nn::nfc::server::core::MifareWriteParameter& src) NN_NOEXCEPT;

//to Nfc
void ConvertToNfcNfcProtocol(nn::nfc::NfcProtocol* pOutDst, const nn::xcd::NfcProtocol& src) NN_NOEXCEPT;
void ConvertToNfcTagType(nn::nfc::TagType* pOutDst, const nn::xcd::NfcTagType& src) NN_NOEXCEPT;
void ConvertToNfcTagId(nn::nfc::TagId* pOutDst, const nn::xcd::NfcTagId& src) NN_NOEXCEPT;
void ConvertToNfcTagInfo(nn::nfc::TagInfo* pOutDst, const nn::xcd::NfcTagInfo& src) NN_NOEXCEPT;
void ConvertToNfcNtagData(nn::nfc::server::core::NtagData* pOutDst, const nn::xcd::NfcNtagData& src) NN_NOEXCEPT;
void ConvertToNfcPassThruData(nn::nfc::server::core::PassThruData* pOutDst, const nn::xcd::NfcPassThruData& src) NN_NOEXCEPT;
void ConvertToNfcInfo(nn::nfc::server::core::Info* pOutDst, const nn::xcd::NfcInfo& src) NN_NOEXCEPT;

nn::Result ConvertToNfcResult(nn::Result result) NN_NOEXCEPT;

bool GetRequiredMcuVersion(nn::xcd::McuVersionDataForNfc* pOutRequiredVersion, nn::xcd::DeviceType deviceType, const nn::nfc::server::core::McuVersionData& mcuVersionData) NN_NOEXCEPT;

nn::Result SetDataFormatSync(nn::xcd::PeriodicDataFormat targetDataFormat, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result SetMcuStateWithRetry(nn::xcd::McuState targetMcuState, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result WaitMcuState(nn::xcd::McuState targetMcuState, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result SetMcuStateSync(nn::xcd::McuState targetMcuState, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StartDiscoveryWithRetry(const nn::nfc::server::core::DiscoveryParameter& discoveryParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StopDiscoveryWithRetry(nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StartNtagReadWithRetry(const nn::nfc::server::core::NtagReadParameter& ntagReadParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StartNtagWriteWithRetry(const nn::nfc::server::core::NtagWriteParameter& ntagWriteParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result SendRawDataWithRetry(const nn::nfc::server::core::PassThruParameter& passThruParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result GetMcuVersionForNfcWithRetry(nn::xcd::McuVersionDataForNfc* pOutMcuVersionData, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StartMifareReadWithRetry(const nn::nfc::server::core::MifareReadParameter& mifareReadParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;
nn::Result StartMifareWriteWithRetry(const nn::nfc::server::core::MifareWriteParameter& mifareWriteParameter, nn::xcd::DeviceHandle handle) NN_NOEXCEPT;

}}}}  // namespace nn::nfc::server::core
