﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_Mutex.h>
#include <nn/nfc/server/core/nfc_Result.h>
#include <nn/nfc/server/core/nfc_Types.h>

namespace nn { namespace nfc { namespace server { namespace core {

    class Tag
    {
        NN_DISALLOW_COPY(Tag);
        NN_DISALLOW_MOVE(Tag);

    public:
        Tag(const nn::xcd::DeviceHandle xcdDeviceHandle, const nn::nfc::TagId& id, nn::nfc::NfcProtocol protocol, nn::nfc::TagType type) NN_NOEXCEPT;
        virtual ~Tag() NN_NOEXCEPT;
        bool operator ==(const Tag& rhs) const NN_NOEXCEPT;
        bool operator !=(const Tag& rhs) const NN_NOEXCEPT;

        nn::nfc::TagId GetId() NN_NOEXCEPT;
        nn::nfc::NfcProtocol GetProtocol() NN_NOEXCEPT;
        nn::nfc::TagType GetType() NN_NOEXCEPT;
        nn::Result SendRawData(const PassThruParameter& passThruParameter) NN_NOEXCEPT;

    private:
        Tag() NN_NOEXCEPT;

    protected:
        nn::xcd::DeviceHandle m_XcdDeviceHandle;
        nn::nfc::TagId m_Id;
        nn::nfc::NfcProtocol m_Protocol;
        nn::nfc::TagType m_Type;
        mutable nn::os::MutexType m_Mutex;
    };

}}}}  // namespace nn::nfc::server::core
