﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <memory>
#include <nn/nn_SdkLog.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/xcd/xcd.h>
#include "nfc_CoreTag.h"
#include <nn/nfc/server/util/nfc_UtilUtil.h>
#include "nfc_LocalUtil.h"
#include <nn/nfc/server/util/nfc_ScopedMutexLock.h>

namespace nn { namespace nfc { namespace server { namespace core {

namespace
{
}

Tag::Tag(const nn::xcd::DeviceHandle xcdDeviceHandle, const nn::nfc::TagId& id, nn::nfc::NfcProtocol protocol, nn::nfc::TagType type) NN_NOEXCEPT : m_XcdDeviceHandle(xcdDeviceHandle), m_Id(id), m_Protocol(protocol), m_Type(type)
{
    nn::os::InitializeMutex(&m_Mutex, true, 0);
}

Tag::~Tag() NN_NOEXCEPT
{
    nn::os::FinalizeMutex(&m_Mutex);
};

bool Tag::operator ==(const Tag& rhs) const NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return nn::nfc::server::util::IsEqualTagId(m_Id, rhs.m_Id);
}

bool Tag::operator !=(const Tag& rhs) const NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return !nn::nfc::server::util::IsEqualTagId(m_Id, rhs.m_Id);
}

nn::nfc::TagId Tag::GetId() NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return m_Id;
}

nn::nfc::NfcProtocol Tag::GetProtocol() NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return m_Protocol;
}

nn::nfc::TagType Tag::GetType() NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return m_Type;
}

nn::Result Tag::SendRawData(const PassThruParameter& passThruParameter) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Mutex);
    return SendRawDataWithRetry(passThruParameter, m_XcdDeviceHandle);
}

}}}}  // namespace nn::nfc::server::core
