﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_CoreManager.h>
#include <nn/nfc/server/util/nfc_ScopedLockShared.h>
#include <nn/nfc/pt/server/nfc_PtManager.h>
#include <nn/nfc/server/nfc_Manager.h>
#include <nn/nfc/server/util/nfc_UtilUtil.h>

namespace nn { namespace nfc { namespace pt { namespace server {

namespace
{
}

Manager::Manager(nn::nfc::server::Manager* manager) NN_NOEXCEPT : m_Manager(manager)
{
}

Manager::~Manager() NN_NOEXCEPT
{
}

nn::Result Manager::SendCommand(void* pOutBuffer, size_t* pOutSize, nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedLockShared lock(m_Manager->m_ReaderWriterLock);

    NN_NFC_SERVER_MANAGER_ACCESS_DEVICE_RETURN(m_Manager, service, deviceHandle, SendCommandByPassThrough(pOutBuffer, pOutSize, service, pData, dataSize, bufferSize, timeout));
}

nn::Result Manager::KeepSession(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedLockShared lock(m_Manager->m_ReaderWriterLock);

    NN_NFC_SERVER_MANAGER_ACCESS_DEVICE_RETURN(m_Manager, service, deviceHandle, KeepPassThroughSession(service));
}

nn::Result Manager::ReleaseSession(nn::nfc::server::core::Service* service, const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedLockShared lock(m_Manager->m_ReaderWriterLock);

    NN_NFC_SERVER_MANAGER_ACCESS_DEVICE_RETURN(m_Manager, service, deviceHandle, ReleasePassThroughSession());
}

}}}}  // namespace nn::nfc::pt::server
