﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/nfc_PassThroughApi.h>
#include <nn/nfc/client/nfc_CommonInterface.h>
#include "detail/nfc_Util.h"

namespace nn { namespace nfc {

namespace
{
}

nn::Result SendCommandByPassThrough(void* pOutBuffer, size_t* pOutSize, const nn::nfc::DeviceHandle& deviceHandle, const void* pData, size_t dataSize, size_t bufferSize, nn::TimeSpan timeout) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutBuffer);
    NN_SDK_REQUIRES_NOT_NULL(pOutSize);
    NN_SDK_REQUIRES_NOT_NULL(pData);
    NN_SDK_REQUIRES(0 < dataSize);
    NN_SDK_REQUIRES(0 < bufferSize);

    nn::sf::OutBuffer buffer(reinterpret_cast<char*>(pOutBuffer), bufferSize);
    uint32_t outSize = 0;
    nn::sf::InBuffer data(reinterpret_cast<char*>(const_cast<void*>(pData)), dataSize);

    NN_NFC_DETAIL_RESULT_DO(NN_NFC_CLIENT_GET_COMMON_INTERFACE(SendCommandByPassThrough, (buffer, &outSize, deviceHandle, data, timeout)));
    *pOutSize = static_cast<size_t>(outSize);
    NN_RESULT_SUCCESS;
}

nn::Result KeepPassThroughSession(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(KeepPassThroughSession, (deviceHandle)));
}

nn::Result ReleasePassThroughSession(const nn::nfc::DeviceHandle& deviceHandle) NN_NOEXCEPT
{
    NN_NFC_DETAIL_RETURN(NN_NFC_CLIENT_GET_COMMON_INTERFACE(ReleasePassThroughSession, (deviceHandle)));
}

}}
