﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkLog.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_CoreManager.h>
#include <nn/nfc/mifare/server/nfc_MifareDevice.h>
#include "nfc_MifareMifare.h"
#include <nn/nfc/server/util/nfc_UtilUtil.h>
#include <nn/nfc/server/util/nfc_ScopedMutexLock.h>
#include <nn/nfc/server/core/nfc_ScopedSession.h>
#include <nn/nfc/server/nfc_Device.h>

namespace nn { namespace nfc { namespace mifare { namespace server {

namespace
{
}

Device::Device(nn::nfc::server::Device* device) NN_NOEXCEPT
: m_Device(device)
{
}

Device::~Device() NN_NOEXCEPT
{
}

nn::Result Device::Read(nn::nfc::MifareReadBlockData* pOutBlockData, nn::nfc::server::core::Service* service, const nn::nfc::MifareReadBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Device->m_Mutex);

    NN_RESULT_DO(m_Device->CheckActive());

    nn::nfc::TagInfo tagInfo;
    NN_RESULT_DO(m_Device->GetTagInfo(&tagInfo, service));

    nn::nfc::server::core::ScopedSession session(service, m_Device->m_Handle);
    NN_RESULT_DO(session.Keep());

    if(!Mifare::IsMifare(static_cast<nn::nfc::NfcProtocol>(tagInfo.protocol), static_cast<nn::nfc::TagType>(tagInfo.type)))
    {
        //MIFARE 以外のタグ
        return nn::nfc::ResultInvalidTag();
    }

    std::unique_ptr<Mifare> targetTag(new Mifare(m_Device->m_Handle, m_Device->m_SelectedTagId, &m_Device->m_AccessFinishEvent, &m_Device->m_AccessResetEvent));

    return m_Device->AfterAccessTag(service, &session, targetTag->Read(pOutBlockData, service, pBlockParameter, blockCount));
}

nn::Result Device::Write(nn::nfc::server::core::Service* service, const nn::nfc::MifareWriteBlockParameter* pBlockParameter, size_t blockCount) NN_NOEXCEPT
{
    nn::nfc::server::util::ScopedMutexLock lock(m_Device->m_Mutex);

    NN_RESULT_DO(m_Device->CheckActive());

    nn::nfc::TagInfo tagInfo;
    NN_RESULT_DO(m_Device->GetTagInfo(&tagInfo, service));

    nn::nfc::server::core::ScopedSession session(service, m_Device->m_Handle);
    NN_RESULT_DO(session.Keep());

    if(!Mifare::IsMifare(static_cast<nn::nfc::NfcProtocol>(tagInfo.protocol), static_cast<nn::nfc::TagType>(tagInfo.type)))
    {
        //MIFARE 以外のタグ
        return nn::nfc::ResultInvalidTag();
    }

    std::unique_ptr<Mifare> targetTag(new Mifare(m_Device->m_Handle, m_Device->m_SelectedTagId, &m_Device->m_AccessFinishEvent, &m_Device->m_AccessResetEvent));

    return m_Device->AfterAccessTag(service, &session, targetTag->Write(service, pBlockParameter, blockCount));
}

}}}}  // namespace nn::nfc::mifare::server
