﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/news_ApiDebug.h>
#include <nn/news/news_Result.h>
#include <nn/news/detail/news_ShimLibraryGlobal.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace news {

nn::Result GetNewsDatabaseDump(size_t* outSize, void* buffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outSize);
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES(size > 0);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSession();

    uint64_t actualSize = 0;

    NN_RESULT_DO(session->GetNewsDatabaseDump(&actualSize, nn::sf::OutBuffer(static_cast<char*>(buffer), size)));

    *outSize = static_cast<size_t>(actualSize);

    NN_RESULT_SUCCESS;
}

}}
